/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadImprovementStatus;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadLensesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadSummary> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(WorkloadSummary.getter(WorkloadSummary::workloadId)).setter(WorkloadSummary.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadArn").getter(WorkloadSummary.getter(WorkloadSummary::workloadArn)).setter(WorkloadSummary.setter(Builder::workloadArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadArn").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(WorkloadSummary.getter(WorkloadSummary::workloadName)).setter(WorkloadSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(WorkloadSummary.getter(WorkloadSummary::owner)).setter(WorkloadSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(WorkloadSummary.getter(WorkloadSummary::updatedAt)).setter(WorkloadSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<List<String>> LENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lenses").getter(WorkloadSummary.getter(WorkloadSummary::lenses)).setter(WorkloadSummary.setter(Builder::lenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(WorkloadSummary.getter(WorkloadSummary::riskCountsAsStrings)).setter(WorkloadSummary.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IMPROVEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImprovementStatus").getter(WorkloadSummary.getter(WorkloadSummary::improvementStatusAsString)).setter(WorkloadSummary.setter(Builder::improvementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_ARN_FIELD, WORKLOAD_NAME_FIELD, OWNER_FIELD, UPDATED_AT_FIELD, LENSES_FIELD, RISK_COUNTS_FIELD, IMPROVEMENT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workloadId;
    private final String workloadArn;
    private final String workloadName;
    private final String owner;
    private final Instant updatedAt;
    private final List<String> lenses;
    private final Map<String, Integer> riskCounts;
    private final String improvementStatus;

    private WorkloadSummary(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadArn = builder.workloadArn;
        this.workloadName = builder.workloadName;
        this.owner = builder.owner;
        this.updatedAt = builder.updatedAt;
        this.lenses = builder.lenses;
        this.riskCounts = builder.riskCounts;
        this.improvementStatus = builder.improvementStatus;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public String workloadArn() {
        return this.workloadArn;
    }

    public String workloadName() {
        return this.workloadName;
    }

    public String owner() {
        return this.owner;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public boolean hasLenses() {
        return this.lenses != null && !(this.lenses instanceof SdkAutoConstructList);
    }

    public List<String> lenses() {
        return this.lenses;
    }

    public Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public WorkloadImprovementStatus improvementStatus() {
        return WorkloadImprovementStatus.fromValue(this.improvementStatus);
    }

    public String improvementStatusAsString() {
        return this.improvementStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLenses() ? this.lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadSummary)) {
            return false;
        }
        WorkloadSummary other = (WorkloadSummary)obj;
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadArn(), other.workloadArn()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasLenses() == other.hasLenses() && Objects.equals(this.lenses(), other.lenses()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && Objects.equals(this.improvementStatusAsString(), other.improvementStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"WorkloadSummary").add("WorkloadId", (Object)this.workloadId()).add("WorkloadArn", (Object)this.workloadArn()).add("WorkloadName", (Object)this.workloadName()).add("Owner", (Object)this.owner()).add("UpdatedAt", (Object)this.updatedAt()).add("Lenses", this.hasLenses() ? this.lenses() : null).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("ImprovementStatus", (Object)this.improvementStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadArn": {
                return Optional.ofNullable(clazz.cast(this.workloadArn()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Lenses": {
                return Optional.ofNullable(clazz.cast(this.lenses()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "ImprovementStatus": {
                return Optional.ofNullable(clazz.cast(this.improvementStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadSummary, T> g) {
        return obj -> g.apply((WorkloadSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workloadId;
        private String workloadArn;
        private String workloadName;
        private String owner;
        private Instant updatedAt;
        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private String improvementStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadSummary model) {
            this.workloadId(model.workloadId);
            this.workloadArn(model.workloadArn);
            this.workloadName(model.workloadName);
            this.owner(model.owner);
            this.updatedAt(model.updatedAt);
            this.lenses(model.lenses);
            this.riskCountsWithStrings(model.riskCounts);
            this.improvementStatus(model.improvementStatus);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final String getWorkloadArn() {
            return this.workloadArn;
        }

        @Override
        public final Builder workloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
            return this;
        }

        public final void setWorkloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final Collection<String> getLenses() {
            if (this.lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lenses;
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String ... lenses) {
            this.lenses(Arrays.asList(lenses));
            return this;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        public final String getImprovementStatus() {
            return this.improvementStatus;
        }

        @Override
        public final Builder improvementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
            return this;
        }

        @Override
        public final Builder improvementStatus(WorkloadImprovementStatus improvementStatus) {
            this.improvementStatus(improvementStatus == null ? null : improvementStatus.toString());
            return this;
        }

        public final void setImprovementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
        }

        public WorkloadSummary build() {
            return new WorkloadSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadSummary> {
        public Builder workloadId(String var1);

        public Builder workloadArn(String var1);

        public Builder workloadName(String var1);

        public Builder owner(String var1);

        public Builder updatedAt(Instant var1);

        public Builder lenses(Collection<String> var1);

        public Builder lenses(String ... var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder improvementStatus(String var1);

        public Builder improvementStatus(WorkloadImprovementStatus var1);
    }
}

