/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadShare;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkloadShareResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, UpdateWorkloadShareResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateWorkloadShareResponse.getter(UpdateWorkloadShareResponse::workloadId)).setter(UpdateWorkloadShareResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<WorkloadShare> WORKLOAD_SHARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkloadShare").getter(UpdateWorkloadShareResponse.getter(UpdateWorkloadShareResponse::workloadShare)).setter(UpdateWorkloadShareResponse.setter(Builder::workloadShare)).constructor(WorkloadShare::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadShare").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_SHARE_FIELD));
    private final String workloadId;
    private final WorkloadShare workloadShare;

    private UpdateWorkloadShareResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.workloadShare = builder.workloadShare;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public WorkloadShare workloadShare() {
        return this.workloadShare;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadShare());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadShareResponse)) {
            return false;
        }
        UpdateWorkloadShareResponse other = (UpdateWorkloadShareResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadShare(), other.workloadShare());
    }

    public String toString() {
        return ToString.builder((String)"UpdateWorkloadShareResponse").add("WorkloadId", (Object)this.workloadId()).add("WorkloadShare", (Object)this.workloadShare()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadShare": {
                return Optional.ofNullable(clazz.cast(this.workloadShare()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadShareResponse, T> g) {
        return obj -> g.apply((UpdateWorkloadShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private WorkloadShare workloadShare;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadShareResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.workloadShare(model.workloadShare);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final WorkloadShare.Builder getWorkloadShare() {
            return this.workloadShare != null ? this.workloadShare.toBuilder() : null;
        }

        @Override
        public final Builder workloadShare(WorkloadShare workloadShare) {
            this.workloadShare = workloadShare;
            return this;
        }

        public final void setWorkloadShare(WorkloadShare.BuilderImpl workloadShare) {
            this.workloadShare = workloadShare != null ? workloadShare.build() : null;
        }

        @Override
        public UpdateWorkloadShareResponse build() {
            return new UpdateWorkloadShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkloadShareResponse> {
        public Builder workloadId(String var1);

        public Builder workloadShare(WorkloadShare var1);

        default public Builder workloadShare(Consumer<WorkloadShare.Builder> workloadShare) {
            return this.workloadShare((WorkloadShare)((WorkloadShare.Builder)WorkloadShare.builder().applyMutation(workloadShare)).build());
        }
    }
}

