/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.LensReviewSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.LensReviewSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLensReviewsResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListLensReviewsResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListLensReviewsResponse.getter(ListLensReviewsResponse::workloadId)).setter(ListLensReviewsResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(ListLensReviewsResponse.getter(ListLensReviewsResponse::milestoneNumber)).setter(ListLensReviewsResponse.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<List<LensReviewSummary>> LENS_REVIEW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LensReviewSummaries").getter(ListLensReviewsResponse.getter(ListLensReviewsResponse::lensReviewSummaries)).setter(ListLensReviewsResponse.setter(Builder::lensReviewSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensReviewSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LensReviewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLensReviewsResponse.getter(ListLensReviewsResponse::nextToken)).setter(ListLensReviewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_NUMBER_FIELD, LENS_REVIEW_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String workloadId;
    private final Integer milestoneNumber;
    private final List<LensReviewSummary> lensReviewSummaries;
    private final String nextToken;

    private ListLensReviewsResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensReviewSummaries = builder.lensReviewSummaries;
        this.nextToken = builder.nextToken;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public boolean hasLensReviewSummaries() {
        return this.lensReviewSummaries != null && !(this.lensReviewSummaries instanceof SdkAutoConstructList);
    }

    public List<LensReviewSummary> lensReviewSummaries() {
        return this.lensReviewSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLensReviewSummaries() ? this.lensReviewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensReviewsResponse)) {
            return false;
        }
        ListLensReviewsResponse other = (ListLensReviewsResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && this.hasLensReviewSummaries() == other.hasLensReviewSummaries() && Objects.equals(this.lensReviewSummaries(), other.lensReviewSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLensReviewsResponse").add("WorkloadId", (Object)this.workloadId()).add("MilestoneNumber", (Object)this.milestoneNumber()).add("LensReviewSummaries", this.hasLensReviewSummaries() ? this.lensReviewSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "LensReviewSummaries": {
                return Optional.ofNullable(clazz.cast(this.lensReviewSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLensReviewsResponse, T> g) {
        return obj -> g.apply((ListLensReviewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private Integer milestoneNumber;
        private List<LensReviewSummary> lensReviewSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensReviewsResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestoneNumber(model.milestoneNumber);
            this.lensReviewSummaries(model.lensReviewSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        public final Collection<LensReviewSummary.Builder> getLensReviewSummaries() {
            if (this.lensReviewSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lensReviewSummaries != null ? (Collection)this.lensReviewSummaries.stream().map(LensReviewSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lensReviewSummaries(Collection<LensReviewSummary> lensReviewSummaries) {
            this.lensReviewSummaries = LensReviewSummariesCopier.copy(lensReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensReviewSummaries(LensReviewSummary ... lensReviewSummaries) {
            this.lensReviewSummaries(Arrays.asList(lensReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensReviewSummaries(Consumer<LensReviewSummary.Builder> ... lensReviewSummaries) {
            this.lensReviewSummaries(Stream.of(lensReviewSummaries).map(c -> (LensReviewSummary)((LensReviewSummary.Builder)LensReviewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLensReviewSummaries(Collection<LensReviewSummary.BuilderImpl> lensReviewSummaries) {
            this.lensReviewSummaries = LensReviewSummariesCopier.copyFromBuilder(lensReviewSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLensReviewsResponse build() {
            return new ListLensReviewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLensReviewsResponse> {
        public Builder workloadId(String var1);

        public Builder milestoneNumber(Integer var1);

        public Builder lensReviewSummaries(Collection<LensReviewSummary> var1);

        public Builder lensReviewSummaries(LensReviewSummary ... var1);

        public Builder lensReviewSummaries(Consumer<LensReviewSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

