/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.AnswerSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.AnswerSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnswersResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListAnswersResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListAnswersResponse.getter(ListAnswersResponse::workloadId)).setter(ListAnswersResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(ListAnswersResponse.getter(ListAnswersResponse::milestoneNumber)).setter(ListAnswersResponse.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(ListAnswersResponse.getter(ListAnswersResponse::lensAlias)).setter(ListAnswersResponse.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<List<AnswerSummary>> ANSWER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnswerSummaries").getter(ListAnswersResponse.getter(ListAnswersResponse::answerSummaries)).setter(ListAnswersResponse.setter(Builder::answerSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnswerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnswersResponse.getter(ListAnswersResponse::nextToken)).setter(ListAnswersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_NUMBER_FIELD, LENS_ALIAS_FIELD, ANSWER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String workloadId;
    private final Integer milestoneNumber;
    private final String lensAlias;
    private final List<AnswerSummary> answerSummaries;
    private final String nextToken;

    private ListAnswersResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensAlias = builder.lensAlias;
        this.answerSummaries = builder.answerSummaries;
        this.nextToken = builder.nextToken;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public String lensAlias() {
        return this.lensAlias;
    }

    public boolean hasAnswerSummaries() {
        return this.answerSummaries != null && !(this.answerSummaries instanceof SdkAutoConstructList);
    }

    public List<AnswerSummary> answerSummaries() {
        return this.answerSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnswerSummaries() ? this.answerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnswersResponse)) {
            return false;
        }
        ListAnswersResponse other = (ListAnswersResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && Objects.equals(this.lensAlias(), other.lensAlias()) && this.hasAnswerSummaries() == other.hasAnswerSummaries() && Objects.equals(this.answerSummaries(), other.answerSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAnswersResponse").add("WorkloadId", (Object)this.workloadId()).add("MilestoneNumber", (Object)this.milestoneNumber()).add("LensAlias", (Object)this.lensAlias()).add("AnswerSummaries", this.hasAnswerSummaries() ? this.answerSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "AnswerSummaries": {
                return Optional.ofNullable(clazz.cast(this.answerSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnswersResponse, T> g) {
        return obj -> g.apply((ListAnswersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private Integer milestoneNumber;
        private String lensAlias;
        private List<AnswerSummary> answerSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnswersResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestoneNumber(model.milestoneNumber);
            this.lensAlias(model.lensAlias);
            this.answerSummaries(model.answerSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final Collection<AnswerSummary.Builder> getAnswerSummaries() {
            if (this.answerSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.answerSummaries != null ? (Collection)this.answerSummaries.stream().map(AnswerSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder answerSummaries(Collection<AnswerSummary> answerSummaries) {
            this.answerSummaries = AnswerSummariesCopier.copy(answerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(AnswerSummary ... answerSummaries) {
            this.answerSummaries(Arrays.asList(answerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(Consumer<AnswerSummary.Builder> ... answerSummaries) {
            this.answerSummaries(Stream.of(answerSummaries).map(c -> (AnswerSummary)((AnswerSummary.Builder)AnswerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnswerSummaries(Collection<AnswerSummary.BuilderImpl> answerSummaries) {
            this.answerSummaries = AnswerSummariesCopier.copyFromBuilder(answerSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAnswersResponse build() {
            return new ListAnswersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnswersResponse> {
        public Builder workloadId(String var1);

        public Builder milestoneNumber(Integer var1);

        public Builder lensAlias(String var1);

        public Builder answerSummaries(Collection<AnswerSummary> var1);

        public Builder answerSummaries(AnswerSummary ... var1);

        public Builder answerSummaries(Consumer<AnswerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

