/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensReviewReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensReviewReport> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensReviewReport.getter(LensReviewReport::lensAlias)).setter(LensReviewReport.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> BASE64_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Base64String").getter(LensReviewReport.getter(LensReviewReport::base64String)).setter(LensReviewReport.setter(Builder::base64String)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base64String").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, BASE64_STRING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lensAlias;
    private final String base64String;

    private LensReviewReport(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.base64String = builder.base64String;
    }

    public String lensAlias() {
        return this.lensAlias;
    }

    public String base64String() {
        return this.base64String;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.base64String());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReviewReport)) {
            return false;
        }
        LensReviewReport other = (LensReviewReport)obj;
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.base64String(), other.base64String());
    }

    public String toString() {
        return ToString.builder((String)"LensReviewReport").add("LensAlias", (Object)this.lensAlias()).add("Base64String", (Object)this.base64String()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "Base64String": {
                return Optional.ofNullable(clazz.cast(this.base64String()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensReviewReport, T> g) {
        return obj -> g.apply((LensReviewReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensAlias;
        private String base64String;

        private BuilderImpl() {
        }

        private BuilderImpl(LensReviewReport model) {
            this.lensAlias(model.lensAlias);
            this.base64String(model.base64String);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getBase64String() {
            return this.base64String;
        }

        @Override
        public final Builder base64String(String base64String) {
            this.base64String = base64String;
            return this;
        }

        public final void setBase64String(String base64String) {
            this.base64String = base64String;
        }

        public LensReviewReport build() {
            return new LensReviewReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensReviewReport> {
        public Builder lensAlias(String var1);

        public Builder base64String(String var1);
    }
}

