/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.FieldToMatch;
import software.amazon.awssdk.services.wafv2.model.TextTransformation;
import software.amazon.awssdk.services.wafv2.model.TextTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XssMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XssMatchStatement> {
    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldToMatch").getter(XssMatchStatement.getter(XssMatchStatement::fieldToMatch)).setter(XssMatchStatement.setter(Builder::fieldToMatch)).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()}).build();
    private static final SdkField<List<TextTransformation>> TEXT_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextTransformations").getter(XssMatchStatement.getter(XssMatchStatement::textTransformations)).setter(XssMatchStatement.setter(Builder::textTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TO_MATCH_FIELD, TEXT_TRANSFORMATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = XssMatchStatement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FieldToMatch fieldToMatch;
    private final List<TextTransformation> textTransformations;

    private XssMatchStatement(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformations = builder.textTransformations;
    }

    public final FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public final boolean hasTextTransformations() {
        return this.textTransformations != null && !(this.textTransformations instanceof SdkAutoConstructList);
    }

    public final List<TextTransformation> textTransformations() {
        return this.textTransformations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextTransformations() ? this.textTransformations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchStatement)) {
            return false;
        }
        XssMatchStatement other = (XssMatchStatement)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && this.hasTextTransformations() == other.hasTextTransformations() && Objects.equals(this.textTransformations(), other.textTransformations());
    }

    public final String toString() {
        return ToString.builder((String)"XssMatchStatement").add("FieldToMatch", (Object)this.fieldToMatch()).add("TextTransformations", this.hasTextTransformations() ? this.textTransformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "TextTransformations": {
                return Optional.ofNullable(clazz.cast(this.textTransformations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldToMatch", FIELD_TO_MATCH_FIELD);
        map.put("TextTransformations", TEXT_TRANSFORMATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<XssMatchStatement, T> g) {
        return obj -> g.apply((XssMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private List<TextTransformation> textTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchStatement model) {
            this.fieldToMatch(model.fieldToMatch);
            this.textTransformations(model.textTransformations);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final List<TextTransformation.Builder> getTextTransformations() {
            List<TextTransformation.Builder> result = TextTransformationsCopier.copyToBuilder(this.textTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextTransformations(Collection<TextTransformation.BuilderImpl> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copyFromBuilder(textTransformations);
        }

        @Override
        public final Builder textTransformations(Collection<TextTransformation> textTransformations) {
            this.textTransformations = TextTransformationsCopier.copy(textTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(TextTransformation ... textTransformations) {
            this.textTransformations(Arrays.asList(textTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTransformations(Consumer<TextTransformation.Builder> ... textTransformations) {
            this.textTransformations(Stream.of(textTransformations).map(c -> (TextTransformation)((TextTransformation.Builder)TextTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public XssMatchStatement build() {
            return new XssMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XssMatchStatement> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder textTransformations(Collection<TextTransformation> var1);

        public Builder textTransformations(TextTransformation ... var1);

        public Builder textTransformations(Consumer<TextTransformation.Builder> ... var1);
    }
}

