/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.BodyParsingFallbackBehavior;
import software.amazon.awssdk.services.wafv2.model.JsonMatchPattern;
import software.amazon.awssdk.services.wafv2.model.JsonMatchScope;
import software.amazon.awssdk.services.wafv2.model.OversizeHandling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JsonBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JsonBody> {
    private static final SdkField<JsonMatchPattern> MATCH_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MatchPattern").getter(JsonBody.getter(JsonBody::matchPattern)).setter(JsonBody.setter(Builder::matchPattern)).constructor(JsonMatchPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPattern").build()}).build();
    private static final SdkField<String> MATCH_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchScope").getter(JsonBody.getter(JsonBody::matchScopeAsString)).setter(JsonBody.setter(Builder::matchScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchScope").build()}).build();
    private static final SdkField<String> INVALID_FALLBACK_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvalidFallbackBehavior").getter(JsonBody.getter(JsonBody::invalidFallbackBehaviorAsString)).setter(JsonBody.setter(Builder::invalidFallbackBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidFallbackBehavior").build()}).build();
    private static final SdkField<String> OVERSIZE_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OversizeHandling").getter(JsonBody.getter(JsonBody::oversizeHandlingAsString)).setter(JsonBody.setter(Builder::oversizeHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OversizeHandling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_PATTERN_FIELD, MATCH_SCOPE_FIELD, INVALID_FALLBACK_BEHAVIOR_FIELD, OVERSIZE_HANDLING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JsonBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final JsonMatchPattern matchPattern;
    private final String matchScope;
    private final String invalidFallbackBehavior;
    private final String oversizeHandling;

    private JsonBody(BuilderImpl builder) {
        this.matchPattern = builder.matchPattern;
        this.matchScope = builder.matchScope;
        this.invalidFallbackBehavior = builder.invalidFallbackBehavior;
        this.oversizeHandling = builder.oversizeHandling;
    }

    public final JsonMatchPattern matchPattern() {
        return this.matchPattern;
    }

    public final JsonMatchScope matchScope() {
        return JsonMatchScope.fromValue(this.matchScope);
    }

    public final String matchScopeAsString() {
        return this.matchScope;
    }

    public final BodyParsingFallbackBehavior invalidFallbackBehavior() {
        return BodyParsingFallbackBehavior.fromValue(this.invalidFallbackBehavior);
    }

    public final String invalidFallbackBehaviorAsString() {
        return this.invalidFallbackBehavior;
    }

    public final OversizeHandling oversizeHandling() {
        return OversizeHandling.fromValue(this.oversizeHandling);
    }

    public final String oversizeHandlingAsString() {
        return this.oversizeHandling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidFallbackBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oversizeHandlingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonBody)) {
            return false;
        }
        JsonBody other = (JsonBody)obj;
        return Objects.equals(this.matchPattern(), other.matchPattern()) && Objects.equals(this.matchScopeAsString(), other.matchScopeAsString()) && Objects.equals(this.invalidFallbackBehaviorAsString(), other.invalidFallbackBehaviorAsString()) && Objects.equals(this.oversizeHandlingAsString(), other.oversizeHandlingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JsonBody").add("MatchPattern", (Object)this.matchPattern()).add("MatchScope", (Object)this.matchScopeAsString()).add("InvalidFallbackBehavior", (Object)this.invalidFallbackBehaviorAsString()).add("OversizeHandling", (Object)this.oversizeHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchPattern": {
                return Optional.ofNullable(clazz.cast(this.matchPattern()));
            }
            case "MatchScope": {
                return Optional.ofNullable(clazz.cast(this.matchScopeAsString()));
            }
            case "InvalidFallbackBehavior": {
                return Optional.ofNullable(clazz.cast(this.invalidFallbackBehaviorAsString()));
            }
            case "OversizeHandling": {
                return Optional.ofNullable(clazz.cast(this.oversizeHandlingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchPattern", MATCH_PATTERN_FIELD);
        map.put("MatchScope", MATCH_SCOPE_FIELD);
        map.put("InvalidFallbackBehavior", INVALID_FALLBACK_BEHAVIOR_FIELD);
        map.put("OversizeHandling", OVERSIZE_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JsonBody, T> g) {
        return obj -> g.apply((JsonBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JsonMatchPattern matchPattern;
        private String matchScope;
        private String invalidFallbackBehavior;
        private String oversizeHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonBody model) {
            this.matchPattern(model.matchPattern);
            this.matchScope(model.matchScope);
            this.invalidFallbackBehavior(model.invalidFallbackBehavior);
            this.oversizeHandling(model.oversizeHandling);
        }

        public final JsonMatchPattern.Builder getMatchPattern() {
            return this.matchPattern != null ? this.matchPattern.toBuilder() : null;
        }

        public final void setMatchPattern(JsonMatchPattern.BuilderImpl matchPattern) {
            this.matchPattern = matchPattern != null ? matchPattern.build() : null;
        }

        @Override
        public final Builder matchPattern(JsonMatchPattern matchPattern) {
            this.matchPattern = matchPattern;
            return this;
        }

        public final String getMatchScope() {
            return this.matchScope;
        }

        public final void setMatchScope(String matchScope) {
            this.matchScope = matchScope;
        }

        @Override
        public final Builder matchScope(String matchScope) {
            this.matchScope = matchScope;
            return this;
        }

        @Override
        public final Builder matchScope(JsonMatchScope matchScope) {
            this.matchScope(matchScope == null ? null : matchScope.toString());
            return this;
        }

        public final String getInvalidFallbackBehavior() {
            return this.invalidFallbackBehavior;
        }

        public final void setInvalidFallbackBehavior(String invalidFallbackBehavior) {
            this.invalidFallbackBehavior = invalidFallbackBehavior;
        }

        @Override
        public final Builder invalidFallbackBehavior(String invalidFallbackBehavior) {
            this.invalidFallbackBehavior = invalidFallbackBehavior;
            return this;
        }

        @Override
        public final Builder invalidFallbackBehavior(BodyParsingFallbackBehavior invalidFallbackBehavior) {
            this.invalidFallbackBehavior(invalidFallbackBehavior == null ? null : invalidFallbackBehavior.toString());
            return this;
        }

        public final String getOversizeHandling() {
            return this.oversizeHandling;
        }

        public final void setOversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
        }

        @Override
        public final Builder oversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
            return this;
        }

        @Override
        public final Builder oversizeHandling(OversizeHandling oversizeHandling) {
            this.oversizeHandling(oversizeHandling == null ? null : oversizeHandling.toString());
            return this;
        }

        public JsonBody build() {
            return new JsonBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JsonBody> {
        public Builder matchPattern(JsonMatchPattern var1);

        default public Builder matchPattern(Consumer<JsonMatchPattern.Builder> matchPattern) {
            return this.matchPattern((JsonMatchPattern)((JsonMatchPattern.Builder)JsonMatchPattern.builder().applyMutation(matchPattern)).build());
        }

        public Builder matchScope(String var1);

        public Builder matchScope(JsonMatchScope var1);

        public Builder invalidFallbackBehavior(String var1);

        public Builder invalidFallbackBehavior(BodyParsingFallbackBehavior var1);

        public Builder oversizeHandling(String var1);

        public Builder oversizeHandling(OversizeHandling var1);
    }
}

