/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TextTransformationType {
    NONE("NONE"),

    COMPRESS_WHITE_SPACE("COMPRESS_WHITE_SPACE"),

    HTML_ENTITY_DECODE("HTML_ENTITY_DECODE"),

    LOWERCASE("LOWERCASE"),

    CMD_LINE("CMD_LINE"),

    URL_DECODE("URL_DECODE"),

    BASE64_DECODE("BASE64_DECODE"),

    HEX_DECODE("HEX_DECODE"),

    MD5("MD5"),

    REPLACE_COMMENTS("REPLACE_COMMENTS"),

    ESCAPE_SEQ_DECODE("ESCAPE_SEQ_DECODE"),

    SQL_HEX_DECODE("SQL_HEX_DECODE"),

    CSS_DECODE("CSS_DECODE"),

    JS_DECODE("JS_DECODE"),

    NORMALIZE_PATH("NORMALIZE_PATH"),

    NORMALIZE_PATH_WIN("NORMALIZE_PATH_WIN"),

    REMOVE_NULLS("REMOVE_NULLS"),

    REPLACE_NULLS("REPLACE_NULLS"),

    BASE64_DECODE_EXT("BASE64_DECODE_EXT"),

    URL_DECODE_UNI("URL_DECODE_UNI"),

    UTF8_TO_UNICODE("UTF8_TO_UNICODE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TextTransformationType> VALUE_MAP = EnumUtils.uniqueIndex(TextTransformationType.class,
            TextTransformationType::toString);

    private final String value;

    private TextTransformationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TextTransformationType corresponding to the value
     */
    public static TextTransformationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TextTransformationType}s
     */
    public static Set<TextTransformationType> knownValues() {
        Set<TextTransformationType> knownValues = EnumSet.allOf(TextTransformationType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
