/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to
 * bypass detection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<TextTransformation.Builder, TextTransformation> {
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(TextTransformation::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TextTransformation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer priority;

    private final String type;

    private TextTransformation(BuilderImpl builder) {
        this.priority = builder.priority;
        this.type = builder.type;
    }

    /**
     * <p>
     * Sets the relative processing order for multiple transformations. WAF processes all transformations, from lowest
     * priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but
     * they must all be different.
     * </p>
     * 
     * @return Sets the relative processing order for multiple transformations. WAF processes all transformations, from
     *         lowest priority to highest, before inspecting the transformed content. The priorities don't need to be
     *         consecutive, but they must all be different.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * For detailed descriptions of each of the transformation types, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text
     * transformations</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TextTransformationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return For detailed descriptions of each of the transformation types, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text
     *         transformations</a> in the <i>WAF Developer Guide</i>.
     * @see TextTransformationType
     */
    public final TextTransformationType type() {
        return TextTransformationType.fromValue(type);
    }

    /**
     * <p>
     * For detailed descriptions of each of the transformation types, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text
     * transformations</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TextTransformationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return For detailed descriptions of each of the transformation types, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text
     *         transformations</a> in the <i>WAF Developer Guide</i>.
     * @see TextTransformationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextTransformation)) {
            return false;
        }
        TextTransformation other = (TextTransformation) obj;
        return Objects.equals(priority(), other.priority()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextTransformation").add("Priority", priority()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Priority", PRIORITY_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextTransformation, T> g) {
        return obj -> g.apply((TextTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextTransformation> {
        /**
         * <p>
         * Sets the relative processing order for multiple transformations. WAF processes all transformations, from
         * lowest priority to highest, before inspecting the transformed content. The priorities don't need to be
         * consecutive, but they must all be different.
         * </p>
         * 
         * @param priority
         *        Sets the relative processing order for multiple transformations. WAF processes all transformations,
         *        from lowest priority to highest, before inspecting the transformed content. The priorities don't need
         *        to be consecutive, but they must all be different.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * For detailed descriptions of each of the transformation types, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text
         * transformations</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        For detailed descriptions of each of the transformation types, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html"
         *        >Text transformations</a> in the <i>WAF Developer Guide</i>.
         * @see TextTransformationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextTransformationType
         */
        Builder type(String type);

        /**
         * <p>
         * For detailed descriptions of each of the transformation types, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html">Text
         * transformations</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        For detailed descriptions of each of the transformation types, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html"
         *        >Text transformations</a> in the <i>WAF Developer Guide</i>.
         * @see TextTransformationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextTransformationType
         */
        Builder type(TextTransformationType type);
    }

    static final class BuilderImpl implements Builder {
        private Integer priority;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TextTransformation model) {
            priority(model.priority);
            type(model.type);
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TextTransformationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TextTransformation build() {
            return new TextTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
