/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApiKeysResponse extends Wafv2Response implements
        ToCopyableBuilder<ListApiKeysResponse.Builder, ListApiKeysResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListApiKeysResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<APIKeySummary>> API_KEY_SUMMARIES_FIELD = SdkField
            .<List<APIKeySummary>> builder(MarshallingType.LIST)
            .memberName("APIKeySummaries")
            .getter(getter(ListApiKeysResponse::apiKeySummaries))
            .setter(setter(Builder::apiKeySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIKeySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<APIKeySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(APIKeySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_INTEGRATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIntegrationURL").getter(getter(ListApiKeysResponse::applicationIntegrationURL))
            .setter(setter(Builder::applicationIntegrationURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIntegrationURL").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            API_KEY_SUMMARIES_FIELD, APPLICATION_INTEGRATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final List<APIKeySummary> apiKeySummaries;

    private final String applicationIntegrationURL;

    private ListApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.apiKeySummaries = builder.apiKeySummaries;
        this.applicationIntegrationURL = builder.applicationIntegrationURL;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
     * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
     * retrieve the next batch of objects, provide the marker from the prior call in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are
     *         still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the
     *         response. To retrieve the next batch of objects, provide the marker from the prior call in your next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the APIKeySummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApiKeySummaries() {
        return apiKeySummaries != null && !(apiKeySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be the full
     * list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApiKeySummaries} method.
     * </p>
     * 
     * @return The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be the
     *         full list.
     */
    public final List<APIKeySummary> apiKeySummaries() {
        return apiKeySummaries;
    }

    /**
     * <p>
     * The CAPTCHA application integration URL, for use in your JavaScript implementation.
     * </p>
     * 
     * @return The CAPTCHA application integration URL, for use in your JavaScript implementation.
     */
    public final String applicationIntegrationURL() {
        return applicationIntegrationURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasApiKeySummaries() ? apiKeySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationIntegrationURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeysResponse)) {
            return false;
        }
        ListApiKeysResponse other = (ListApiKeysResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasApiKeySummaries() == other.hasApiKeySummaries()
                && Objects.equals(apiKeySummaries(), other.apiKeySummaries())
                && Objects.equals(applicationIntegrationURL(), other.applicationIntegrationURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApiKeysResponse").add("NextMarker", nextMarker())
                .add("APIKeySummaries", hasApiKeySummaries() ? apiKeySummaries() : null)
                .add("ApplicationIntegrationURL", applicationIntegrationURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "APIKeySummaries":
            return Optional.ofNullable(clazz.cast(apiKeySummaries()));
        case "ApplicationIntegrationURL":
            return Optional.ofNullable(clazz.cast(applicationIntegrationURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("APIKeySummaries", API_KEY_SUMMARIES_FIELD);
        map.put("ApplicationIntegrationURL", APPLICATION_INTEGRATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApiKeysResponse, T> g) {
        return obj -> g.apply((ListApiKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListApiKeysResponse> {
        /**
         * <p>
         * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
         * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
         * retrieve the next batch of objects, provide the marker from the prior call in your next request.
         * </p>
         * 
         * @param nextMarker
         *        When you request a list of objects with a <code>Limit</code> setting, if the number of objects that
         *        are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in
         *        the response. To retrieve the next batch of objects, provide the marker from the prior call in your
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be the full
         * list.
         * </p>
         * 
         * @param apiKeySummaries
         *        The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be
         *        the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySummaries(Collection<APIKeySummary> apiKeySummaries);

        /**
         * <p>
         * The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be the full
         * list.
         * </p>
         * 
         * @param apiKeySummaries
         *        The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be
         *        the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySummaries(APIKeySummary... apiKeySummaries);

        /**
         * <p>
         * The array of key summaries. If you specified a <code>Limit</code> in your request, this might not be the full
         * list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.APIKeySummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.APIKeySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.APIKeySummary.Builder#build()} is called immediately and
         * its result is passed to {@link #apiKeySummaries(List<APIKeySummary>)}.
         * 
         * @param apiKeySummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.APIKeySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeySummaries(java.util.Collection<APIKeySummary>)
         */
        Builder apiKeySummaries(Consumer<APIKeySummary.Builder>... apiKeySummaries);

        /**
         * <p>
         * The CAPTCHA application integration URL, for use in your JavaScript implementation.
         * </p>
         * 
         * @param applicationIntegrationURL
         *        The CAPTCHA application integration URL, for use in your JavaScript implementation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIntegrationURL(String applicationIntegrationURL);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String nextMarker;

        private List<APIKeySummary> apiKeySummaries = DefaultSdkAutoConstructList.getInstance();

        private String applicationIntegrationURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeysResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            apiKeySummaries(model.apiKeySummaries);
            applicationIntegrationURL(model.applicationIntegrationURL);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<APIKeySummary.Builder> getApiKeySummaries() {
            List<APIKeySummary.Builder> result = APIKeySummariesCopier.copyToBuilder(this.apiKeySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiKeySummaries(Collection<APIKeySummary.BuilderImpl> apiKeySummaries) {
            this.apiKeySummaries = APIKeySummariesCopier.copyFromBuilder(apiKeySummaries);
        }

        @Override
        public final Builder apiKeySummaries(Collection<APIKeySummary> apiKeySummaries) {
            this.apiKeySummaries = APIKeySummariesCopier.copy(apiKeySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeySummaries(APIKeySummary... apiKeySummaries) {
            apiKeySummaries(Arrays.asList(apiKeySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeySummaries(Consumer<APIKeySummary.Builder>... apiKeySummaries) {
            apiKeySummaries(Stream.of(apiKeySummaries).map(c -> APIKeySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationIntegrationURL() {
            return applicationIntegrationURL;
        }

        public final void setApplicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
        }

        @Override
        public final Builder applicationIntegrationURL(String applicationIntegrationURL) {
            this.applicationIntegrationURL = applicationIntegrationURL;
            return this;
        }

        @Override
        public ListApiKeysResponse build() {
            return new ListApiKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
