/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A WAF feature that is not supported by the CloudFront pricing plan associated with the web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisallowedFeature implements SdkPojo, Serializable,
        ToCopyableBuilder<DisallowedFeature.Builder, DisallowedFeature> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(DisallowedFeature::feature)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()).build();

    private static final SdkField<String> REQUIRED_PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequiredPricingPlan").getter(getter(DisallowedFeature::requiredPricingPlan))
            .setter(setter(Builder::requiredPricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredPricingPlan").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD,
            REQUIRED_PRICING_PLAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String feature;

    private final String requiredPricingPlan;

    private DisallowedFeature(BuilderImpl builder) {
        this.feature = builder.feature;
        this.requiredPricingPlan = builder.requiredPricingPlan;
    }

    /**
     * <p>
     * The name of the disallowed WAF feature.
     * </p>
     * 
     * @return The name of the disallowed WAF feature.
     */
    public final String feature() {
        return feature;
    }

    /**
     * <p>
     * The name of the CloudFront pricing plan required to use the WAF feature.
     * </p>
     * 
     * @return The name of the CloudFront pricing plan required to use the WAF feature.
     */
    public final String requiredPricingPlan() {
        return requiredPricingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(feature());
        hashCode = 31 * hashCode + Objects.hashCode(requiredPricingPlan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisallowedFeature)) {
            return false;
        }
        DisallowedFeature other = (DisallowedFeature) obj;
        return Objects.equals(feature(), other.feature()) && Objects.equals(requiredPricingPlan(), other.requiredPricingPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisallowedFeature").add("Feature", feature()).add("RequiredPricingPlan", requiredPricingPlan())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Feature":
            return Optional.ofNullable(clazz.cast(feature()));
        case "RequiredPricingPlan":
            return Optional.ofNullable(clazz.cast(requiredPricingPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Feature", FEATURE_FIELD);
        map.put("RequiredPricingPlan", REQUIRED_PRICING_PLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisallowedFeature, T> g) {
        return obj -> g.apply((DisallowedFeature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisallowedFeature> {
        /**
         * <p>
         * The name of the disallowed WAF feature.
         * </p>
         * 
         * @param feature
         *        The name of the disallowed WAF feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feature(String feature);

        /**
         * <p>
         * The name of the CloudFront pricing plan required to use the WAF feature.
         * </p>
         * 
         * @param requiredPricingPlan
         *        The name of the CloudFront pricing plan required to use the WAF feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredPricingPlan(String requiredPricingPlan);
    }

    static final class BuilderImpl implements Builder {
        private String feature;

        private String requiredPricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(DisallowedFeature model) {
            feature(model.feature);
            requiredPricingPlan(model.requiredPricingPlan);
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public final String getRequiredPricingPlan() {
            return requiredPricingPlan;
        }

        public final void setRequiredPricingPlan(String requiredPricingPlan) {
            this.requiredPricingPlan = requiredPricingPlan;
        }

        @Override
        public final Builder requiredPricingPlan(String requiredPricingPlan) {
            this.requiredPricingPlan = requiredPricingPlan;
            return this;
        }

        @Override
        public DisallowedFeature build() {
            return new DisallowedFeature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
