/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is part of the configuration for the managed rules <code>AWSManagedRulesAntiDDoSRuleSet</code> in
 * <code>ManagedRuleGroupConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientSideActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientSideActionConfig.Builder, ClientSideActionConfig> {
    private static final SdkField<ClientSideAction> CHALLENGE_FIELD = SdkField
            .<ClientSideAction> builder(MarshallingType.SDK_POJO).memberName("Challenge")
            .getter(getter(ClientSideActionConfig::challenge)).setter(setter(Builder::challenge))
            .constructor(ClientSideAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Challenge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClientSideAction challenge;

    private ClientSideActionConfig(BuilderImpl builder) {
        this.challenge = builder.challenge;
    }

    /**
     * <p>
     * Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
     * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>.
     * </p>
     * <note>
     * <p>
     * This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only configures
     * the use of the two anti-DDoS rules named here.
     * </p>
     * </note>
     * <p>
     * You can enable or disable the use of these rules, and you can configure how to use them when they are enabled.
     * </p>
     * 
     * @return Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>. </p> <note>
     *         <p>
     *         This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only
     *         configures the use of the two anti-DDoS rules named here.
     *         </p>
     *         </note>
     *         <p>
     *         You can enable or disable the use of these rules, and you can configure how to use them when they are
     *         enabled.
     */
    public final ClientSideAction challenge() {
        return challenge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(challenge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientSideActionConfig)) {
            return false;
        }
        ClientSideActionConfig other = (ClientSideActionConfig) obj;
        return Objects.equals(challenge(), other.challenge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientSideActionConfig").add("Challenge", challenge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Challenge":
            return Optional.ofNullable(clazz.cast(challenge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Challenge", CHALLENGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientSideActionConfig, T> g) {
        return obj -> g.apply((ClientSideActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientSideActionConfig> {
        /**
         * <p>
         * Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>.
         * </p>
         * <note>
         * <p>
         * This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only
         * configures the use of the two anti-DDoS rules named here.
         * </p>
         * </note>
         * <p>
         * You can enable or disable the use of these rules, and you can configure how to use them when they are
         * enabled.
         * </p>
         * 
         * @param challenge
         *        Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         *        <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>. </p> <note>
         *        <p>
         *        This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only
         *        configures the use of the two anti-DDoS rules named here.
         *        </p>
         *        </note>
         *        <p>
         *        You can enable or disable the use of these rules, and you can configure how to use them when they are
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challenge(ClientSideAction challenge);

        /**
         * <p>
         * Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code>.
         * </p>
         * <note>
         * <p>
         * This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only
         * configures the use of the two anti-DDoS rules named here.
         * </p>
         * </note>
         * <p>
         * You can enable or disable the use of these rules, and you can configure how to use them when they are
         * enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientSideAction.Builder} avoiding the
         * need to create one manually via {@link ClientSideAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientSideAction.Builder#build()} is called immediately and its
         * result is passed to {@link #challenge(ClientSideAction)}.
         * 
         * @param challenge
         *        a consumer that will call methods on {@link ClientSideAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challenge(ClientSideAction)
         */
        default Builder challenge(Consumer<ClientSideAction.Builder> challenge) {
            return challenge(ClientSideAction.builder().applyMutation(challenge).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClientSideAction challenge;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientSideActionConfig model) {
            challenge(model.challenge);
        }

        public final ClientSideAction.Builder getChallenge() {
            return challenge != null ? challenge.toBuilder() : null;
        }

        public final void setChallenge(ClientSideAction.BuilderImpl challenge) {
            this.challenge = challenge != null ? challenge.build() : null;
        }

        @Override
        public final Builder challenge(ClientSideAction challenge) {
            this.challenge = challenge;
            return this;
        }

        @Override
        public ClientSideActionConfig build() {
            return new ClientSideActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
