/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the use of the anti-DDoS managed rule group, <code>AWSManagedRulesAntiDDoSRuleSet</code>. This
 * configuration is used in <code>ManagedRuleGroupConfig</code>.
 * </p>
 * <p>
 * The configuration that you provide here determines whether and how the rules in the rule group are used.
 * </p>
 * <p>
 * For additional information about this and the other intelligent threat mitigation rule groups, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-managed-protections">Intelligent threat mitigation in
 * WAF</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list">Amazon Web
 * Services Managed Rules rule groups list</a> in the <i>WAF Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AWSManagedRulesAntiDDoSRuleSet implements SdkPojo, Serializable,
        ToCopyableBuilder<AWSManagedRulesAntiDDoSRuleSet.Builder, AWSManagedRulesAntiDDoSRuleSet> {
    private static final SdkField<ClientSideActionConfig> CLIENT_SIDE_ACTION_CONFIG_FIELD = SdkField
            .<ClientSideActionConfig> builder(MarshallingType.SDK_POJO).memberName("ClientSideActionConfig")
            .getter(getter(AWSManagedRulesAntiDDoSRuleSet::clientSideActionConfig))
            .setter(setter(Builder::clientSideActionConfig)).constructor(ClientSideActionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSideActionConfig").build())
            .build();

    private static final SdkField<String> SENSITIVITY_TO_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SensitivityToBlock").getter(getter(AWSManagedRulesAntiDDoSRuleSet::sensitivityToBlockAsString))
            .setter(setter(Builder::sensitivityToBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensitivityToBlock").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLIENT_SIDE_ACTION_CONFIG_FIELD, SENSITIVITY_TO_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClientSideActionConfig clientSideActionConfig;

    private final String sensitivityToBlock;

    private AWSManagedRulesAntiDDoSRuleSet(BuilderImpl builder) {
        this.clientSideActionConfig = builder.clientSideActionConfig;
        this.sensitivityToBlock = builder.sensitivityToBlock;
    }

    /**
     * <p>
     * Configures the request handling that's applied by the managed rule group rules
     * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial of
     * service (DDoS) attack.
     * </p>
     * 
     * @return Configures the request handling that's applied by the managed rule group rules
     *         <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial
     *         of service (DDoS) attack.
     */
    public final ClientSideActionConfig clientSideActionConfig() {
        return clientSideActionConfig;
    }

    /**
     * <p>
     * The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS suspicion
     * labeling on a request. The managed rule group adds the labeling during DDoS events, before the
     * <code>DDoSRequests</code> rule runs.
     * </p>
     * <p>
     * The higher the sensitivity, the more levels of labeling that the rule matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack,
     * which are the requests with the high suspicion label
     * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>LOW</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sensitivityToBlock} will return {@link SensitivityToAct#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #sensitivityToBlockAsString}.
     * </p>
     * 
     * @return The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS
     *         suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
     *         <code>DDoSRequests</code> rule runs. </p>
     *         <p>
     *         The higher the sensitivity, the more levels of labeling that the rule matches:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
     *         attack, which are the requests with the high suspicion label
     *         <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>LOW</code>
     * @see SensitivityToAct
     */
    public final SensitivityToAct sensitivityToBlock() {
        return SensitivityToAct.fromValue(sensitivityToBlock);
    }

    /**
     * <p>
     * The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS suspicion
     * labeling on a request. The managed rule group adds the labeling during DDoS events, before the
     * <code>DDoSRequests</code> rule runs.
     * </p>
     * <p>
     * The higher the sensitivity, the more levels of labeling that the rule matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack,
     * which are the requests with the high suspicion label
     * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>LOW</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sensitivityToBlock} will return {@link SensitivityToAct#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #sensitivityToBlockAsString}.
     * </p>
     * 
     * @return The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS
     *         suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
     *         <code>DDoSRequests</code> rule runs. </p>
     *         <p>
     *         The higher the sensitivity, the more levels of labeling that the rule matches:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
     *         attack, which are the requests with the high suspicion label
     *         <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Medium sensitivity causes the rule to match on the medium and high suspicion labels.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>LOW</code>
     * @see SensitivityToAct
     */
    public final String sensitivityToBlockAsString() {
        return sensitivityToBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientSideActionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityToBlockAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesAntiDDoSRuleSet)) {
            return false;
        }
        AWSManagedRulesAntiDDoSRuleSet other = (AWSManagedRulesAntiDDoSRuleSet) obj;
        return Objects.equals(clientSideActionConfig(), other.clientSideActionConfig())
                && Objects.equals(sensitivityToBlockAsString(), other.sensitivityToBlockAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AWSManagedRulesAntiDDoSRuleSet").add("ClientSideActionConfig", clientSideActionConfig())
                .add("SensitivityToBlock", sensitivityToBlockAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientSideActionConfig":
            return Optional.ofNullable(clazz.cast(clientSideActionConfig()));
        case "SensitivityToBlock":
            return Optional.ofNullable(clazz.cast(sensitivityToBlockAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientSideActionConfig", CLIENT_SIDE_ACTION_CONFIG_FIELD);
        map.put("SensitivityToBlock", SENSITIVITY_TO_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesAntiDDoSRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesAntiDDoSRuleSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AWSManagedRulesAntiDDoSRuleSet> {
        /**
         * <p>
         * Configures the request handling that's applied by the managed rule group rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial of
         * service (DDoS) attack.
         * </p>
         * 
         * @param clientSideActionConfig
         *        Configures the request handling that's applied by the managed rule group rules
         *        <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed
         *        denial of service (DDoS) attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSideActionConfig(ClientSideActionConfig clientSideActionConfig);

        /**
         * <p>
         * Configures the request handling that's applied by the managed rule group rules
         * <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial of
         * service (DDoS) attack.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientSideActionConfig.Builder} avoiding
         * the need to create one manually via {@link ClientSideActionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientSideActionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #clientSideActionConfig(ClientSideActionConfig)}.
         * 
         * @param clientSideActionConfig
         *        a consumer that will call methods on {@link ClientSideActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientSideActionConfig(ClientSideActionConfig)
         */
        default Builder clientSideActionConfig(Consumer<ClientSideActionConfig.Builder> clientSideActionConfig) {
            return clientSideActionConfig(ClientSideActionConfig.builder().applyMutation(clientSideActionConfig).build());
        }

        /**
         * <p>
         * The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS
         * suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
         * <code>DDoSRequests</code> rule runs.
         * </p>
         * <p>
         * The higher the sensitivity, the more levels of labeling that the rule matches:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
         * attack, which are the requests with the high suspicion label
         * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         * </p>
         * </li>
         * <li>
         * <p>
         * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>LOW</code>
         * </p>
         * 
         * @param sensitivityToBlock
         *        The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS
         *        suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before
         *        the <code>DDoSRequests</code> rule runs. </p>
         *        <p>
         *        The higher the sensitivity, the more levels of labeling that the rule matches:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in
         *        an attack, which are the requests with the high suspicion label
         *        <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>LOW</code>
         * @see SensitivityToAct
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SensitivityToAct
         */
        Builder sensitivityToBlock(String sensitivityToBlock);

        /**
         * <p>
         * The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS
         * suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before the
         * <code>DDoSRequests</code> rule runs.
         * </p>
         * <p>
         * The higher the sensitivity, the more levels of labeling that the rule matches:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an
         * attack, which are the requests with the high suspicion label
         * <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         * </p>
         * </li>
         * <li>
         * <p>
         * High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>LOW</code>
         * </p>
         * 
         * @param sensitivityToBlock
         *        The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS
         *        suspicion labeling on a request. The managed rule group adds the labeling during DDoS events, before
         *        the <code>DDoSRequests</code> rule runs. </p>
         *        <p>
         *        The higher the sensitivity, the more levels of labeling that the rule matches:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in
         *        an attack, which are the requests with the high suspicion label
         *        <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Medium sensitivity causes the rule to match on the medium and high suspicion labels.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>LOW</code>
         * @see SensitivityToAct
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SensitivityToAct
         */
        Builder sensitivityToBlock(SensitivityToAct sensitivityToBlock);
    }

    static final class BuilderImpl implements Builder {
        private ClientSideActionConfig clientSideActionConfig;

        private String sensitivityToBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesAntiDDoSRuleSet model) {
            clientSideActionConfig(model.clientSideActionConfig);
            sensitivityToBlock(model.sensitivityToBlock);
        }

        public final ClientSideActionConfig.Builder getClientSideActionConfig() {
            return clientSideActionConfig != null ? clientSideActionConfig.toBuilder() : null;
        }

        public final void setClientSideActionConfig(ClientSideActionConfig.BuilderImpl clientSideActionConfig) {
            this.clientSideActionConfig = clientSideActionConfig != null ? clientSideActionConfig.build() : null;
        }

        @Override
        public final Builder clientSideActionConfig(ClientSideActionConfig clientSideActionConfig) {
            this.clientSideActionConfig = clientSideActionConfig;
            return this;
        }

        public final String getSensitivityToBlock() {
            return sensitivityToBlock;
        }

        public final void setSensitivityToBlock(String sensitivityToBlock) {
            this.sensitivityToBlock = sensitivityToBlock;
        }

        @Override
        public final Builder sensitivityToBlock(String sensitivityToBlock) {
            this.sensitivityToBlock = sensitivityToBlock;
            return this;
        }

        @Override
        public final Builder sensitivityToBlock(SensitivityToAct sensitivityToBlock) {
            this.sensitivityToBlock(sensitivityToBlock == null ? null : sensitivityToBlock.toString());
            return this;
        }

        @Override
        public AWSManagedRulesAntiDDoSRuleSet build() {
            return new AWSManagedRulesAntiDDoSRuleSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
