/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldToProtectType {
    SINGLE_HEADER("SINGLE_HEADER"),
    SINGLE_COOKIE("SINGLE_COOKIE"),
    SINGLE_QUERY_ARGUMENT("SINGLE_QUERY_ARGUMENT"),
    QUERY_STRING("QUERY_STRING"),
    BODY("BODY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldToProtectType> VALUE_MAP;
    private final String value;

    private FieldToProtectType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldToProtectType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldToProtectType> knownValues() {
        EnumSet<FieldToProtectType> knownValues = EnumSet.allOf(FieldToProtectType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldToProtectType.class, FieldToProtectType::toString);
    }
}

