/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FallbackBehavior {
    MATCH("MATCH"),
    NO_MATCH("NO_MATCH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FallbackBehavior> VALUE_MAP;
    private final String value;

    private FallbackBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FallbackBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FallbackBehavior> knownValues() {
        EnumSet<FallbackBehavior> knownValues = EnumSet.allOf(FallbackBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FallbackBehavior.class, FallbackBehavior::toString);
    }
}

