/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SensitivityLevel {
    LOW("LOW"),
    HIGH("HIGH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SensitivityLevel> VALUE_MAP;
    private final String value;

    private SensitivityLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SensitivityLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SensitivityLevel> knownValues() {
        EnumSet<SensitivityLevel> knownValues = EnumSet.allOf(SensitivityLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SensitivityLevel.class, SensitivityLevel::toString);
    }
}

