/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.FieldToProtectKeysCopier;
import software.amazon.awssdk.services.wafv2.model.FieldToProtectType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldToProtect
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldToProtect> {
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldType").getter(FieldToProtect.getter(FieldToProtect::fieldTypeAsString)).setter(FieldToProtect.setter(Builder::fieldType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldType").build()}).build();
    private static final SdkField<List<String>> FIELD_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldKeys").getter(FieldToProtect.getter(FieldToProtect::fieldKeys)).setter(FieldToProtect.setter(Builder::fieldKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TYPE_FIELD, FIELD_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FieldToProtect.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldType;
    private final List<String> fieldKeys;

    private FieldToProtect(BuilderImpl builder) {
        this.fieldType = builder.fieldType;
        this.fieldKeys = builder.fieldKeys;
    }

    public final FieldToProtectType fieldType() {
        return FieldToProtectType.fromValue(this.fieldType);
    }

    public final String fieldTypeAsString() {
        return this.fieldType;
    }

    public final boolean hasFieldKeys() {
        return this.fieldKeys != null && !(this.fieldKeys instanceof SdkAutoConstructList);
    }

    public final List<String> fieldKeys() {
        return this.fieldKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldKeys() ? this.fieldKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToProtect)) {
            return false;
        }
        FieldToProtect other = (FieldToProtect)obj;
        return Objects.equals(this.fieldTypeAsString(), other.fieldTypeAsString()) && this.hasFieldKeys() == other.hasFieldKeys() && Objects.equals(this.fieldKeys(), other.fieldKeys());
    }

    public final String toString() {
        return ToString.builder((String)"FieldToProtect").add("FieldType", (Object)this.fieldTypeAsString()).add("FieldKeys", this.hasFieldKeys() ? this.fieldKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldType": {
                return Optional.ofNullable(clazz.cast(this.fieldTypeAsString()));
            }
            case "FieldKeys": {
                return Optional.ofNullable(clazz.cast(this.fieldKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldType", FIELD_TYPE_FIELD);
        map.put("FieldKeys", FIELD_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldToProtect, T> g) {
        return obj -> g.apply((FieldToProtect)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldType;
        private List<String> fieldKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToProtect model) {
            this.fieldType(model.fieldType);
            this.fieldKeys(model.fieldKeys);
        }

        public final String getFieldType() {
            return this.fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public final Builder fieldType(FieldToProtectType fieldType) {
            this.fieldType(fieldType == null ? null : fieldType.toString());
            return this;
        }

        public final Collection<String> getFieldKeys() {
            if (this.fieldKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fieldKeys;
        }

        public final void setFieldKeys(Collection<String> fieldKeys) {
            this.fieldKeys = FieldToProtectKeysCopier.copy(fieldKeys);
        }

        @Override
        public final Builder fieldKeys(Collection<String> fieldKeys) {
            this.fieldKeys = FieldToProtectKeysCopier.copy(fieldKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldKeys(String ... fieldKeys) {
            this.fieldKeys(Arrays.asList(fieldKeys));
            return this;
        }

        public FieldToProtect build() {
            return new FieldToProtect(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldToProtect> {
        public Builder fieldType(String var1);

        public Builder fieldType(FieldToProtectType var1);

        public Builder fieldKeys(Collection<String> var1);

        public Builder fieldKeys(String ... var1);
    }
}

