/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.RequestInspection;
import software.amazon.awssdk.services.wafv2.model.ResponseInspection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AWSManagedRulesATPRuleSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AWSManagedRulesATPRuleSet> {
    private static final SdkField<String> LOGIN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoginPath").getter(AWSManagedRulesATPRuleSet.getter(AWSManagedRulesATPRuleSet::loginPath)).setter(AWSManagedRulesATPRuleSet.setter(Builder::loginPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginPath").build()}).build();
    private static final SdkField<RequestInspection> REQUEST_INSPECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestInspection").getter(AWSManagedRulesATPRuleSet.getter(AWSManagedRulesATPRuleSet::requestInspection)).setter(AWSManagedRulesATPRuleSet.setter(Builder::requestInspection)).constructor(RequestInspection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestInspection").build()}).build();
    private static final SdkField<ResponseInspection> RESPONSE_INSPECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseInspection").getter(AWSManagedRulesATPRuleSet.getter(AWSManagedRulesATPRuleSet::responseInspection)).setter(AWSManagedRulesATPRuleSet.setter(Builder::responseInspection)).constructor(ResponseInspection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseInspection").build()}).build();
    private static final SdkField<Boolean> ENABLE_REGEX_IN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableRegexInPath").getter(AWSManagedRulesATPRuleSet.getter(AWSManagedRulesATPRuleSet::enableRegexInPath)).setter(AWSManagedRulesATPRuleSet.setter(Builder::enableRegexInPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableRegexInPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIN_PATH_FIELD, REQUEST_INSPECTION_FIELD, RESPONSE_INSPECTION_FIELD, ENABLE_REGEX_IN_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LoginPath", LOGIN_PATH_FIELD);
            this.put("RequestInspection", REQUEST_INSPECTION_FIELD);
            this.put("ResponseInspection", RESPONSE_INSPECTION_FIELD);
            this.put("EnableRegexInPath", ENABLE_REGEX_IN_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String loginPath;
    private final RequestInspection requestInspection;
    private final ResponseInspection responseInspection;
    private final Boolean enableRegexInPath;

    private AWSManagedRulesATPRuleSet(BuilderImpl builder) {
        this.loginPath = builder.loginPath;
        this.requestInspection = builder.requestInspection;
        this.responseInspection = builder.responseInspection;
        this.enableRegexInPath = builder.enableRegexInPath;
    }

    public final String loginPath() {
        return this.loginPath;
    }

    public final RequestInspection requestInspection() {
        return this.requestInspection;
    }

    public final ResponseInspection responseInspection() {
        return this.responseInspection;
    }

    public final Boolean enableRegexInPath() {
        return this.enableRegexInPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loginPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestInspection());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseInspection());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableRegexInPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesATPRuleSet)) {
            return false;
        }
        AWSManagedRulesATPRuleSet other = (AWSManagedRulesATPRuleSet)obj;
        return Objects.equals(this.loginPath(), other.loginPath()) && Objects.equals(this.requestInspection(), other.requestInspection()) && Objects.equals(this.responseInspection(), other.responseInspection()) && Objects.equals(this.enableRegexInPath(), other.enableRegexInPath());
    }

    public final String toString() {
        return ToString.builder((String)"AWSManagedRulesATPRuleSet").add("LoginPath", (Object)this.loginPath()).add("RequestInspection", (Object)this.requestInspection()).add("ResponseInspection", (Object)this.responseInspection()).add("EnableRegexInPath", (Object)this.enableRegexInPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoginPath": {
                return Optional.ofNullable(clazz.cast(this.loginPath()));
            }
            case "RequestInspection": {
                return Optional.ofNullable(clazz.cast(this.requestInspection()));
            }
            case "ResponseInspection": {
                return Optional.ofNullable(clazz.cast(this.responseInspection()));
            }
            case "EnableRegexInPath": {
                return Optional.ofNullable(clazz.cast(this.enableRegexInPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesATPRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesATPRuleSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String loginPath;
        private RequestInspection requestInspection;
        private ResponseInspection responseInspection;
        private Boolean enableRegexInPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesATPRuleSet model) {
            this.loginPath(model.loginPath);
            this.requestInspection(model.requestInspection);
            this.responseInspection(model.responseInspection);
            this.enableRegexInPath(model.enableRegexInPath);
        }

        public final String getLoginPath() {
            return this.loginPath;
        }

        public final void setLoginPath(String loginPath) {
            this.loginPath = loginPath;
        }

        @Override
        public final Builder loginPath(String loginPath) {
            this.loginPath = loginPath;
            return this;
        }

        public final RequestInspection.Builder getRequestInspection() {
            return this.requestInspection != null ? this.requestInspection.toBuilder() : null;
        }

        public final void setRequestInspection(RequestInspection.BuilderImpl requestInspection) {
            this.requestInspection = requestInspection != null ? requestInspection.build() : null;
        }

        @Override
        public final Builder requestInspection(RequestInspection requestInspection) {
            this.requestInspection = requestInspection;
            return this;
        }

        public final ResponseInspection.Builder getResponseInspection() {
            return this.responseInspection != null ? this.responseInspection.toBuilder() : null;
        }

        public final void setResponseInspection(ResponseInspection.BuilderImpl responseInspection) {
            this.responseInspection = responseInspection != null ? responseInspection.build() : null;
        }

        @Override
        public final Builder responseInspection(ResponseInspection responseInspection) {
            this.responseInspection = responseInspection;
            return this;
        }

        public final Boolean getEnableRegexInPath() {
            return this.enableRegexInPath;
        }

        public final void setEnableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
        }

        @Override
        public final Builder enableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
            return this;
        }

        public AWSManagedRulesATPRuleSet build() {
            return new AWSManagedRulesATPRuleSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AWSManagedRulesATPRuleSet> {
        public Builder loginPath(String var1);

        public Builder requestInspection(RequestInspection var1);

        default public Builder requestInspection(Consumer<RequestInspection.Builder> requestInspection) {
            return this.requestInspection((RequestInspection)((RequestInspection.Builder)RequestInspection.builder().applyMutation(requestInspection)).build());
        }

        public Builder responseInspection(ResponseInspection var1);

        default public Builder responseInspection(Consumer<ResponseInspection.Builder> responseInspection) {
            return this.responseInspection((ResponseInspection)((ResponseInspection.Builder)ResponseInspection.builder().applyMutation(responseInspection)).build());
        }

        public Builder enableRegexInPath(Boolean var1);
    }
}

