/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JsonMatchScope {
    ALL("ALL"),
    KEY("KEY"),
    VALUE("VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JsonMatchScope> VALUE_MAP;
    private final String value;

    private JsonMatchScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JsonMatchScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JsonMatchScope> knownValues() {
        EnumSet<JsonMatchScope> knownValues = EnumSet.allOf(JsonMatchScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JsonMatchScope.class, JsonMatchScope::toString);
    }
}

