/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.All;
import software.amazon.awssdk.services.wafv2.model.JsonPointerPathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JsonMatchPattern
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JsonMatchPattern> {
    private static final SdkField<All> ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("All").getter(JsonMatchPattern.getter(JsonMatchPattern::all)).setter(JsonMatchPattern.setter(Builder::all)).constructor(All::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("All").build()}).build();
    private static final SdkField<List<String>> INCLUDED_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedPaths").getter(JsonMatchPattern.getter(JsonMatchPattern::includedPaths)).setter(JsonMatchPattern.setter(Builder::includedPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD, INCLUDED_PATHS_FIELD));
    private static final long serialVersionUID = 1L;
    private final All all;
    private final List<String> includedPaths;

    private JsonMatchPattern(BuilderImpl builder) {
        this.all = builder.all;
        this.includedPaths = builder.includedPaths;
    }

    public final All all() {
        return this.all;
    }

    public final boolean hasIncludedPaths() {
        return this.includedPaths != null && !(this.includedPaths instanceof SdkAutoConstructList);
    }

    public final List<String> includedPaths() {
        return this.includedPaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.all());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedPaths() ? this.includedPaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonMatchPattern)) {
            return false;
        }
        JsonMatchPattern other = (JsonMatchPattern)obj;
        return Objects.equals(this.all(), other.all()) && this.hasIncludedPaths() == other.hasIncludedPaths() && Objects.equals(this.includedPaths(), other.includedPaths());
    }

    public final String toString() {
        return ToString.builder((String)"JsonMatchPattern").add("All", (Object)this.all()).add("IncludedPaths", this.hasIncludedPaths() ? this.includedPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "All": {
                return Optional.ofNullable(clazz.cast(this.all()));
            }
            case "IncludedPaths": {
                return Optional.ofNullable(clazz.cast(this.includedPaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JsonMatchPattern, T> g) {
        return obj -> g.apply((JsonMatchPattern)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private All all;
        private List<String> includedPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JsonMatchPattern model) {
            this.all(model.all);
            this.includedPaths(model.includedPaths);
        }

        public final All.Builder getAll() {
            return this.all != null ? this.all.toBuilder() : null;
        }

        public final void setAll(All.BuilderImpl all) {
            this.all = all != null ? all.build() : null;
        }

        @Override
        public final Builder all(All all) {
            this.all = all;
            return this;
        }

        public final Collection<String> getIncludedPaths() {
            if (this.includedPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedPaths;
        }

        public final void setIncludedPaths(Collection<String> includedPaths) {
            this.includedPaths = JsonPointerPathsCopier.copy(includedPaths);
        }

        @Override
        public final Builder includedPaths(Collection<String> includedPaths) {
            this.includedPaths = JsonPointerPathsCopier.copy(includedPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedPaths(String ... includedPaths) {
            this.includedPaths(Arrays.asList(includedPaths));
            return this;
        }

        public JsonMatchPattern build() {
            return new JsonMatchPattern(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JsonMatchPattern> {
        public Builder all(All var1);

        default public Builder all(Consumer<All.Builder> all) {
            return this.all((All)((All.Builder)All.builder().applyMutation(all)).build());
        }

        public Builder includedPaths(Collection<String> var1);

        public Builder includedPaths(String ... var1);
    }
}

