/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wafv2.model.CustomResponseBodiesCopier;
import software.amazon.awssdk.services.wafv2.model.CustomResponseBody;
import software.amazon.awssdk.services.wafv2.model.LabelSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.LabelSummary;
import software.amazon.awssdk.services.wafv2.model.Rule;
import software.amazon.awssdk.services.wafv2.model.RulesCopier;
import software.amazon.awssdk.services.wafv2.model.VisibilityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RuleGroup.getter(RuleGroup::name)).setter(RuleGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RuleGroup.getter(RuleGroup::id)).setter(RuleGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Capacity").getter(RuleGroup.getter(RuleGroup::capacity)).setter(RuleGroup.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(RuleGroup.getter(RuleGroup::arn)).setter(RuleGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RuleGroup.getter(RuleGroup::description)).setter(RuleGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(RuleGroup.getter(RuleGroup::rules)).setter(RuleGroup.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(RuleGroup.getter(RuleGroup::visibilityConfig)).setter(RuleGroup.setter(Builder::visibilityConfig)).constructor(VisibilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final SdkField<String> LABEL_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelNamespace").getter(RuleGroup.getter(RuleGroup::labelNamespace)).setter(RuleGroup.setter(Builder::labelNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNamespace").build()}).build();
    private static final SdkField<Map<String, CustomResponseBody>> CUSTOM_RESPONSE_BODIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomResponseBodies").getter(RuleGroup.getter(RuleGroup::customResponseBodies)).setter(RuleGroup.setter(Builder::customResponseBodies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomResponseBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<LabelSummary>> AVAILABLE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableLabels").getter(RuleGroup.getter(RuleGroup::availableLabels)).setter(RuleGroup.setter(Builder::availableLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LabelSummary>> CONSUMED_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedLabels").getter(RuleGroup.getter(RuleGroup::consumedLabels)).setter(RuleGroup.setter(Builder::consumedLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, CAPACITY_FIELD, ARN_FIELD, DESCRIPTION_FIELD, RULES_FIELD, VISIBILITY_CONFIG_FIELD, LABEL_NAMESPACE_FIELD, CUSTOM_RESPONSE_BODIES_FIELD, AVAILABLE_LABELS_FIELD, CONSUMED_LABELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final Long capacity;
    private final String arn;
    private final String description;
    private final List<Rule> rules;
    private final VisibilityConfig visibilityConfig;
    private final String labelNamespace;
    private final Map<String, CustomResponseBody> customResponseBodies;
    private final List<LabelSummary> availableLabels;
    private final List<LabelSummary> consumedLabels;

    private RuleGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.capacity = builder.capacity;
        this.arn = builder.arn;
        this.description = builder.description;
        this.rules = builder.rules;
        this.visibilityConfig = builder.visibilityConfig;
        this.labelNamespace = builder.labelNamespace;
        this.customResponseBodies = builder.customResponseBodies;
        this.availableLabels = builder.availableLabels;
        this.consumedLabels = builder.consumedLabels;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final Long capacity() {
        return this.capacity;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final VisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public final String labelNamespace() {
        return this.labelNamespace;
    }

    public final boolean hasCustomResponseBodies() {
        return this.customResponseBodies != null && !(this.customResponseBodies instanceof SdkAutoConstructMap);
    }

    public final Map<String, CustomResponseBody> customResponseBodies() {
        return this.customResponseBodies;
    }

    public final boolean hasAvailableLabels() {
        return this.availableLabels != null && !(this.availableLabels instanceof SdkAutoConstructList);
    }

    public final List<LabelSummary> availableLabels() {
        return this.availableLabels;
    }

    public final boolean hasConsumedLabels() {
        return this.consumedLabels != null && !(this.consumedLabels instanceof SdkAutoConstructList);
    }

    public final List<LabelSummary> consumedLabels() {
        return this.consumedLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomResponseBodies() ? this.customResponseBodies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableLabels() ? this.availableLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedLabels() ? this.consumedLabels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroup)) {
            return false;
        }
        RuleGroup other = (RuleGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig()) && Objects.equals(this.labelNamespace(), other.labelNamespace()) && this.hasCustomResponseBodies() == other.hasCustomResponseBodies() && Objects.equals(this.customResponseBodies(), other.customResponseBodies()) && this.hasAvailableLabels() == other.hasAvailableLabels() && Objects.equals(this.availableLabels(), other.availableLabels()) && this.hasConsumedLabels() == other.hasConsumedLabels() && Objects.equals(this.consumedLabels(), other.consumedLabels());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroup").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Capacity", (Object)this.capacity()).add("ARN", (Object)this.arn()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).add("VisibilityConfig", (Object)this.visibilityConfig()).add("LabelNamespace", (Object)this.labelNamespace()).add("CustomResponseBodies", this.hasCustomResponseBodies() ? this.customResponseBodies() : null).add("AvailableLabels", this.hasAvailableLabels() ? this.availableLabels() : null).add("ConsumedLabels", this.hasConsumedLabels() ? this.consumedLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
            case "LabelNamespace": {
                return Optional.ofNullable(clazz.cast(this.labelNamespace()));
            }
            case "CustomResponseBodies": {
                return Optional.ofNullable(clazz.cast(this.customResponseBodies()));
            }
            case "AvailableLabels": {
                return Optional.ofNullable(clazz.cast(this.availableLabels()));
            }
            case "ConsumedLabels": {
                return Optional.ofNullable(clazz.cast(this.consumedLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroup, T> g) {
        return obj -> g.apply((RuleGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private Long capacity;
        private String arn;
        private String description;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private VisibilityConfig visibilityConfig;
        private String labelNamespace;
        private Map<String, CustomResponseBody> customResponseBodies = DefaultSdkAutoConstructMap.getInstance();
        private List<LabelSummary> availableLabels = DefaultSdkAutoConstructList.getInstance();
        private List<LabelSummary> consumedLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroup model) {
            this.name(model.name);
            this.id(model.id);
            this.capacity(model.capacity);
            this.arn(model.arn);
            this.description(model.description);
            this.rules(model.rules);
            this.visibilityConfig(model.visibilityConfig);
            this.labelNamespace(model.labelNamespace);
            this.customResponseBodies(model.customResponseBodies);
            this.availableLabels(model.availableLabels);
            this.consumedLabels(model.consumedLabels);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public final String getLabelNamespace() {
            return this.labelNamespace;
        }

        public final void setLabelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
        }

        @Override
        public final Builder labelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
            return this;
        }

        public final Map<String, CustomResponseBody.Builder> getCustomResponseBodies() {
            Map<String, CustomResponseBody.Builder> result = CustomResponseBodiesCopier.copyToBuilder(this.customResponseBodies);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustomResponseBodies(Map<String, CustomResponseBody.BuilderImpl> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copyFromBuilder(customResponseBodies);
        }

        @Override
        public final Builder customResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copy(customResponseBodies);
            return this;
        }

        public final List<LabelSummary.Builder> getAvailableLabels() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.availableLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailableLabels(Collection<LabelSummary.BuilderImpl> availableLabels) {
            this.availableLabels = LabelSummariesCopier.copyFromBuilder(availableLabels);
        }

        @Override
        public final Builder availableLabels(Collection<LabelSummary> availableLabels) {
            this.availableLabels = LabelSummariesCopier.copy(availableLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableLabels(LabelSummary ... availableLabels) {
            this.availableLabels(Arrays.asList(availableLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableLabels(Consumer<LabelSummary.Builder> ... availableLabels) {
            this.availableLabels(Stream.of(availableLabels).map(c -> (LabelSummary)((LabelSummary.Builder)LabelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LabelSummary.Builder> getConsumedLabels() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.consumedLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedLabels(Collection<LabelSummary.BuilderImpl> consumedLabels) {
            this.consumedLabels = LabelSummariesCopier.copyFromBuilder(consumedLabels);
        }

        @Override
        public final Builder consumedLabels(Collection<LabelSummary> consumedLabels) {
            this.consumedLabels = LabelSummariesCopier.copy(consumedLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLabels(LabelSummary ... consumedLabels) {
            this.consumedLabels(Arrays.asList(consumedLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLabels(Consumer<LabelSummary.Builder> ... consumedLabels) {
            this.consumedLabels(Stream.of(consumedLabels).map(c -> (LabelSummary)((LabelSummary.Builder)LabelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RuleGroup build() {
            return new RuleGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroup> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder capacity(Long var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder visibilityConfig(VisibilityConfig var1);

        default public Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return this.visibilityConfig((VisibilityConfig)((VisibilityConfig.Builder)VisibilityConfig.builder().applyMutation(visibilityConfig)).build());
        }

        public Builder labelNamespace(String var1);

        public Builder customResponseBodies(Map<String, CustomResponseBody> var1);

        public Builder availableLabels(Collection<LabelSummary> var1);

        public Builder availableLabels(LabelSummary ... var1);

        public Builder availableLabels(Consumer<LabelSummary.Builder> ... var1);

        public Builder consumedLabels(Collection<LabelSummary> var1);

        public Builder consumedLabels(LabelSummary ... var1);

        public Builder consumedLabels(Consumer<LabelSummary.Builder> ... var1);
    }
}

