/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.wafv2.endpoints.Wafv2EndpointParams;
import software.amazon.awssdk.services.wafv2.endpoints.Wafv2EndpointProvider;
import software.amazon.awssdk.services.wafv2.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Condition;
import software.amazon.awssdk.services.wafv2.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.wafv2.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.wafv2.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Expr;
import software.amazon.awssdk.services.wafv2.endpoints.internal.FnNode;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Identifier;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Parameter;
import software.amazon.awssdk.services.wafv2.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Parameters;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Rule;
import software.amazon.awssdk.services.wafv2.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DefaultWafv2EndpointProvider
implements Wafv2EndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultWafv2EndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(Wafv2EndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultWafv2EndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(Wafv2EndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_3(), DefaultWafv2EndpointProvider.endpointRule_4()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_1(), DefaultWafv2EndpointProvider.endpointRule_2()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://wafv2-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_10() {
        return Rule.builder().treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_12() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_9(), DefaultWafv2EndpointProvider.endpointRule_12()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://wafv2-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_15() {
        return Rule.builder().treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_14(), DefaultWafv2EndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_19(), DefaultWafv2EndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("af-south-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.af-south-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-northeast-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-northeast-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_27() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-northeast-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-northeast-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_28() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-northeast-3"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-northeast-3.amazonaws.com")).build());
    }

    private static Rule endpointRule_29() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-south-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-south-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-southeast-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_31() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-southeast-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_32() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-3"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ap-southeast-3.amazonaws.com")).build());
    }

    private static Rule endpointRule_33() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ca-central-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.ca-central-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_34() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-central-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.eu-central-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_35() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-north-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.eu-north-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_36() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-south-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.eu-south-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_37() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.eu-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_38() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.eu-west-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_39() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-3"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.eu-west-3.amazonaws.com")).build());
    }

    private static Rule endpointRule_40() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("me-south-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.me-south-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_41() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("sa-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.sa-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_42() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.us-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_43() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.us-east-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_44() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.us-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_45() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-west-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.us-west-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_46() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("cn-north-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.cn-north-1.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_47() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("cn-northwest-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.cn-northwest-1.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-gov-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.us-gov-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_49() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-gov-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.us-gov-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_50() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://wafv2.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_23() {
        return Rule.builder().treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_24(), DefaultWafv2EndpointProvider.endpointRule_25(), DefaultWafv2EndpointProvider.endpointRule_26(), DefaultWafv2EndpointProvider.endpointRule_27(), DefaultWafv2EndpointProvider.endpointRule_28(), DefaultWafv2EndpointProvider.endpointRule_29(), DefaultWafv2EndpointProvider.endpointRule_30(), DefaultWafv2EndpointProvider.endpointRule_31(), DefaultWafv2EndpointProvider.endpointRule_32(), DefaultWafv2EndpointProvider.endpointRule_33(), DefaultWafv2EndpointProvider.endpointRule_34(), DefaultWafv2EndpointProvider.endpointRule_35(), DefaultWafv2EndpointProvider.endpointRule_36(), DefaultWafv2EndpointProvider.endpointRule_37(), DefaultWafv2EndpointProvider.endpointRule_38(), DefaultWafv2EndpointProvider.endpointRule_39(), DefaultWafv2EndpointProvider.endpointRule_40(), DefaultWafv2EndpointProvider.endpointRule_41(), DefaultWafv2EndpointProvider.endpointRule_42(), DefaultWafv2EndpointProvider.endpointRule_43(), DefaultWafv2EndpointProvider.endpointRule_44(), DefaultWafv2EndpointProvider.endpointRule_45(), DefaultWafv2EndpointProvider.endpointRule_46(), DefaultWafv2EndpointProvider.endpointRule_47(), DefaultWafv2EndpointProvider.endpointRule_48(), DefaultWafv2EndpointProvider.endpointRule_49(), DefaultWafv2EndpointProvider.endpointRule_50()));
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_8(), DefaultWafv2EndpointProvider.endpointRule_13(), DefaultWafv2EndpointProvider.endpointRule_18(), DefaultWafv2EndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_7()));
    }

    private static Rule endpointRule_51() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultWafv2EndpointProvider.endpointRule_6(), DefaultWafv2EndpointProvider.endpointRule_51()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultWafv2EndpointProvider.endpointRule_0()).addRule(DefaultWafv2EndpointProvider.endpointRule_5()).build();
    }
}

