/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.FirewallManagerStatement;
import software.amazon.awssdk.services.wafv2.model.OverrideAction;
import software.amazon.awssdk.services.wafv2.model.VisibilityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallManagerRuleGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallManagerRuleGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FirewallManagerRuleGroup.getter(FirewallManagerRuleGroup::name)).setter(FirewallManagerRuleGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(FirewallManagerRuleGroup.getter(FirewallManagerRuleGroup::priority)).setter(FirewallManagerRuleGroup.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<FirewallManagerStatement> FIREWALL_MANAGER_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallManagerStatement").getter(FirewallManagerRuleGroup.getter(FirewallManagerRuleGroup::firewallManagerStatement)).setter(FirewallManagerRuleGroup.setter(Builder::firewallManagerStatement)).constructor(FirewallManagerStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallManagerStatement").build()}).build();
    private static final SdkField<OverrideAction> OVERRIDE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideAction").getter(FirewallManagerRuleGroup.getter(FirewallManagerRuleGroup::overrideAction)).setter(FirewallManagerRuleGroup.setter(Builder::overrideAction)).constructor(OverrideAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()}).build();
    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(FirewallManagerRuleGroup.getter(FirewallManagerRuleGroup::visibilityConfig)).setter(FirewallManagerRuleGroup.setter(Builder::visibilityConfig)).constructor(VisibilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRIORITY_FIELD, FIREWALL_MANAGER_STATEMENT_FIELD, OVERRIDE_ACTION_FIELD, VISIBILITY_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer priority;
    private final FirewallManagerStatement firewallManagerStatement;
    private final OverrideAction overrideAction;
    private final VisibilityConfig visibilityConfig;

    private FirewallManagerRuleGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.priority = builder.priority;
        this.firewallManagerStatement = builder.firewallManagerStatement;
        this.overrideAction = builder.overrideAction;
        this.visibilityConfig = builder.visibilityConfig;
    }

    public final String name() {
        return this.name;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final FirewallManagerStatement firewallManagerStatement() {
        return this.firewallManagerStatement;
    }

    public final OverrideAction overrideAction() {
        return this.overrideAction;
    }

    public final VisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallManagerStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallManagerRuleGroup)) {
            return false;
        }
        FirewallManagerRuleGroup other = (FirewallManagerRuleGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.firewallManagerStatement(), other.firewallManagerStatement()) && Objects.equals(this.overrideAction(), other.overrideAction()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallManagerRuleGroup").add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("FirewallManagerStatement", (Object)this.firewallManagerStatement()).add("OverrideAction", (Object)this.overrideAction()).add("VisibilityConfig", (Object)this.visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "FirewallManagerStatement": {
                return Optional.ofNullable(clazz.cast(this.firewallManagerStatement()));
            }
            case "OverrideAction": {
                return Optional.ofNullable(clazz.cast(this.overrideAction()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallManagerRuleGroup, T> g) {
        return obj -> g.apply((FirewallManagerRuleGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer priority;
        private FirewallManagerStatement firewallManagerStatement;
        private OverrideAction overrideAction;
        private VisibilityConfig visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallManagerRuleGroup model) {
            this.name(model.name);
            this.priority(model.priority);
            this.firewallManagerStatement(model.firewallManagerStatement);
            this.overrideAction(model.overrideAction);
            this.visibilityConfig(model.visibilityConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final FirewallManagerStatement.Builder getFirewallManagerStatement() {
            return this.firewallManagerStatement != null ? this.firewallManagerStatement.toBuilder() : null;
        }

        public final void setFirewallManagerStatement(FirewallManagerStatement.BuilderImpl firewallManagerStatement) {
            this.firewallManagerStatement = firewallManagerStatement != null ? firewallManagerStatement.build() : null;
        }

        @Override
        @Transient
        public final Builder firewallManagerStatement(FirewallManagerStatement firewallManagerStatement) {
            this.firewallManagerStatement = firewallManagerStatement;
            return this;
        }

        public final OverrideAction.Builder getOverrideAction() {
            return this.overrideAction != null ? this.overrideAction.toBuilder() : null;
        }

        public final void setOverrideAction(OverrideAction.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        @Override
        @Transient
        public final Builder overrideAction(OverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public FirewallManagerRuleGroup build() {
            return new FirewallManagerRuleGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallManagerRuleGroup> {
        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder firewallManagerStatement(FirewallManagerStatement var1);

        default public Builder firewallManagerStatement(Consumer<FirewallManagerStatement.Builder> firewallManagerStatement) {
            return this.firewallManagerStatement((FirewallManagerStatement)((FirewallManagerStatement.Builder)FirewallManagerStatement.builder().applyMutation(firewallManagerStatement)).build());
        }

        public Builder overrideAction(OverrideAction var1);

        default public Builder overrideAction(Consumer<OverrideAction.Builder> overrideAction) {
            return this.overrideAction((OverrideAction)((OverrideAction.Builder)OverrideAction.builder().applyMutation(overrideAction)).build());
        }

        public Builder visibilityConfig(VisibilityConfig var1);

        default public Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return this.visibilityConfig((VisibilityConfig)((VisibilityConfig.Builder)VisibilityConfig.builder().applyMutation(visibilityConfig)).build());
        }
    }
}

