/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.HTTPHeader;
import software.amazon.awssdk.services.wafv2.model.HTTPHeadersCopier;
import software.amazon.awssdk.services.wafv2.model.HTTPRequest;
import software.amazon.awssdk.services.wafv2.model.Label;
import software.amazon.awssdk.services.wafv2.model.LabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SampledHTTPRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SampledHTTPRequest> {
    private static final SdkField<HTTPRequest> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Request").getter(SampledHTTPRequest.getter(SampledHTTPRequest::request)).setter(SampledHTTPRequest.setter(Builder::request)).constructor(HTTPRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Request").build()}).build();
    private static final SdkField<Long> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Weight").getter(SampledHTTPRequest.getter(SampledHTTPRequest::weight)).setter(SampledHTTPRequest.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(SampledHTTPRequest.getter(SampledHTTPRequest::timestamp)).setter(SampledHTTPRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(SampledHTTPRequest.getter(SampledHTTPRequest::action)).setter(SampledHTTPRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> RULE_NAME_WITHIN_RULE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleNameWithinRuleGroup").getter(SampledHTTPRequest.getter(SampledHTTPRequest::ruleNameWithinRuleGroup)).setter(SampledHTTPRequest.setter(Builder::ruleNameWithinRuleGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNameWithinRuleGroup").build()}).build();
    private static final SdkField<List<HTTPHeader>> REQUEST_HEADERS_INSERTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestHeadersInserted").getter(SampledHTTPRequest.getter(SampledHTTPRequest::requestHeadersInserted)).setter(SampledHTTPRequest.setter(Builder::requestHeadersInserted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestHeadersInserted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HTTPHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RESPONSE_CODE_SENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResponseCodeSent").getter(SampledHTTPRequest.getter(SampledHTTPRequest::responseCodeSent)).setter(SampledHTTPRequest.setter(Builder::responseCodeSent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCodeSent").build()}).build();
    private static final SdkField<List<Label>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(SampledHTTPRequest.getter(SampledHTTPRequest::labels)).setter(SampledHTTPRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Label::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, WEIGHT_FIELD, TIMESTAMP_FIELD, ACTION_FIELD, RULE_NAME_WITHIN_RULE_GROUP_FIELD, REQUEST_HEADERS_INSERTED_FIELD, RESPONSE_CODE_SENT_FIELD, LABELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final HTTPRequest request;
    private final Long weight;
    private final Instant timestamp;
    private final String action;
    private final String ruleNameWithinRuleGroup;
    private final List<HTTPHeader> requestHeadersInserted;
    private final Integer responseCodeSent;
    private final List<Label> labels;

    private SampledHTTPRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.weight = builder.weight;
        this.timestamp = builder.timestamp;
        this.action = builder.action;
        this.ruleNameWithinRuleGroup = builder.ruleNameWithinRuleGroup;
        this.requestHeadersInserted = builder.requestHeadersInserted;
        this.responseCodeSent = builder.responseCodeSent;
        this.labels = builder.labels;
    }

    public final HTTPRequest request() {
        return this.request;
    }

    public final Long weight() {
        return this.weight;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String action() {
        return this.action;
    }

    public final String ruleNameWithinRuleGroup() {
        return this.ruleNameWithinRuleGroup;
    }

    public final boolean hasRequestHeadersInserted() {
        return this.requestHeadersInserted != null && !(this.requestHeadersInserted instanceof SdkAutoConstructList);
    }

    public final List<HTTPHeader> requestHeadersInserted() {
        return this.requestHeadersInserted;
    }

    public final Integer responseCodeSent() {
        return this.responseCodeSent;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<Label> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNameWithinRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestHeadersInserted() ? this.requestHeadersInserted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCodeSent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampledHTTPRequest)) {
            return false;
        }
        SampledHTTPRequest other = (SampledHTTPRequest)obj;
        return Objects.equals(this.request(), other.request()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.ruleNameWithinRuleGroup(), other.ruleNameWithinRuleGroup()) && this.hasRequestHeadersInserted() == other.hasRequestHeadersInserted() && Objects.equals(this.requestHeadersInserted(), other.requestHeadersInserted()) && Objects.equals(this.responseCodeSent(), other.responseCodeSent()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"SampledHTTPRequest").add("Request", (Object)this.request()).add("Weight", (Object)this.weight()).add("Timestamp", (Object)this.timestamp()).add("Action", (Object)this.action()).add("RuleNameWithinRuleGroup", (Object)this.ruleNameWithinRuleGroup()).add("RequestHeadersInserted", this.hasRequestHeadersInserted() ? this.requestHeadersInserted() : null).add("ResponseCodeSent", (Object)this.responseCodeSent()).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "RuleNameWithinRuleGroup": {
                return Optional.ofNullable(clazz.cast(this.ruleNameWithinRuleGroup()));
            }
            case "RequestHeadersInserted": {
                return Optional.ofNullable(clazz.cast(this.requestHeadersInserted()));
            }
            case "ResponseCodeSent": {
                return Optional.ofNullable(clazz.cast(this.responseCodeSent()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SampledHTTPRequest, T> g) {
        return obj -> g.apply((SampledHTTPRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HTTPRequest request;
        private Long weight;
        private Instant timestamp;
        private String action;
        private String ruleNameWithinRuleGroup;
        private List<HTTPHeader> requestHeadersInserted = DefaultSdkAutoConstructList.getInstance();
        private Integer responseCodeSent;
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SampledHTTPRequest model) {
            this.request(model.request);
            this.weight(model.weight);
            this.timestamp(model.timestamp);
            this.action(model.action);
            this.ruleNameWithinRuleGroup(model.ruleNameWithinRuleGroup);
            this.requestHeadersInserted(model.requestHeadersInserted);
            this.responseCodeSent(model.responseCodeSent);
            this.labels(model.labels);
        }

        public final HTTPRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(HTTPRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        @Transient
        public final Builder request(HTTPRequest request) {
            this.request = request;
            return this;
        }

        public final Long getWeight() {
            return this.weight;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        @Override
        @Transient
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getRuleNameWithinRuleGroup() {
            return this.ruleNameWithinRuleGroup;
        }

        public final void setRuleNameWithinRuleGroup(String ruleNameWithinRuleGroup) {
            this.ruleNameWithinRuleGroup = ruleNameWithinRuleGroup;
        }

        @Override
        @Transient
        public final Builder ruleNameWithinRuleGroup(String ruleNameWithinRuleGroup) {
            this.ruleNameWithinRuleGroup = ruleNameWithinRuleGroup;
            return this;
        }

        public final List<HTTPHeader.Builder> getRequestHeadersInserted() {
            List<HTTPHeader.Builder> result = HTTPHeadersCopier.copyToBuilder(this.requestHeadersInserted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestHeadersInserted(Collection<HTTPHeader.BuilderImpl> requestHeadersInserted) {
            this.requestHeadersInserted = HTTPHeadersCopier.copyFromBuilder(requestHeadersInserted);
        }

        @Override
        @Transient
        public final Builder requestHeadersInserted(Collection<HTTPHeader> requestHeadersInserted) {
            this.requestHeadersInserted = HTTPHeadersCopier.copy(requestHeadersInserted);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requestHeadersInserted(HTTPHeader ... requestHeadersInserted) {
            this.requestHeadersInserted(Arrays.asList(requestHeadersInserted));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requestHeadersInserted(Consumer<HTTPHeader.Builder> ... requestHeadersInserted) {
            this.requestHeadersInserted(Stream.of(requestHeadersInserted).map(c -> (HTTPHeader)((HTTPHeader.Builder)HTTPHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getResponseCodeSent() {
            return this.responseCodeSent;
        }

        public final void setResponseCodeSent(Integer responseCodeSent) {
            this.responseCodeSent = responseCodeSent;
        }

        @Override
        @Transient
        public final Builder responseCodeSent(Integer responseCodeSent) {
            this.responseCodeSent = responseCodeSent;
            return this;
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        @Override
        @Transient
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder labels(Label ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (Label)((Label.Builder)Label.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SampledHTTPRequest build() {
            return new SampledHTTPRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SampledHTTPRequest> {
        public Builder request(HTTPRequest var1);

        default public Builder request(Consumer<HTTPRequest.Builder> request) {
            return this.request((HTTPRequest)((HTTPRequest.Builder)HTTPRequest.builder().applyMutation(request)).build());
        }

        public Builder weight(Long var1);

        public Builder timestamp(Instant var1);

        public Builder action(String var1);

        public Builder ruleNameWithinRuleGroup(String var1);

        public Builder requestHeadersInserted(Collection<HTTPHeader> var1);

        public Builder requestHeadersInserted(HTTPHeader ... var1);

        public Builder requestHeadersInserted(Consumer<HTTPHeader.Builder> ... var1);

        public Builder responseCodeSent(Integer var1);

        public Builder labels(Collection<Label> var1);

        public Builder labels(Label ... var1);

        public Builder labels(Consumer<Label.Builder> ... var1);
    }
}

