/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.LabelMatchScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelMatchStatement> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(LabelMatchStatement.getter(LabelMatchStatement::scopeAsString)).setter(LabelMatchStatement.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(LabelMatchStatement.getter(LabelMatchStatement::key)).setter(LabelMatchStatement.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String key;

    private LabelMatchStatement(BuilderImpl builder) {
        this.scope = builder.scope;
        this.key = builder.key;
    }

    public final LabelMatchScope scope() {
        return LabelMatchScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String key() {
        return this.key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelMatchStatement)) {
            return false;
        }
        LabelMatchStatement other = (LabelMatchStatement)obj;
        return Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"LabelMatchStatement").add("Scope", (Object)this.scopeAsString()).add("Key", (Object)this.key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelMatchStatement, T> g) {
        return obj -> g.apply((LabelMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scope;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelMatchStatement model) {
            this.scope(model.scope);
            this.key(model.key);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        @Transient
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        @Transient
        public final Builder scope(LabelMatchScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public LabelMatchStatement build() {
            return new LabelMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelMatchStatement> {
        public Builder scope(String var1);

        public Builder scope(LabelMatchScope var1);

        public Builder key(String var1);
    }
}

