/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wafv2.model.CustomResponseBodiesCopier;
import software.amazon.awssdk.services.wafv2.model.CustomResponseBody;
import software.amazon.awssdk.services.wafv2.model.DefaultAction;
import software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroup;
import software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroupsCopier;
import software.amazon.awssdk.services.wafv2.model.Rule;
import software.amazon.awssdk.services.wafv2.model.RulesCopier;
import software.amazon.awssdk.services.wafv2.model.VisibilityConfig;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebACL
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebACL> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WebACL.getter(WebACL::name)).setter(WebACL.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(WebACL.getter(WebACL::id)).setter(WebACL.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(WebACL.getter(WebACL::arn)).setter(WebACL.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<DefaultAction> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultAction").getter(WebACL.getter(WebACL::defaultAction)).setter(WebACL.setter(Builder::defaultAction)).constructor(DefaultAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WebACL.getter(WebACL::description)).setter(WebACL.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(WebACL.getter(WebACL::rules)).setter(WebACL.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(WebACL.getter(WebACL::visibilityConfig)).setter(WebACL.setter(Builder::visibilityConfig)).constructor(VisibilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Capacity").getter(WebACL.getter(WebACL::capacity)).setter(WebACL.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<List<FirewallManagerRuleGroup>> PRE_PROCESS_FIREWALL_MANAGER_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreProcessFirewallManagerRuleGroups").getter(WebACL.getter(WebACL::preProcessFirewallManagerRuleGroups)).setter(WebACL.setter(Builder::preProcessFirewallManagerRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreProcessFirewallManagerRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallManagerRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FirewallManagerRuleGroup>> POST_PROCESS_FIREWALL_MANAGER_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PostProcessFirewallManagerRuleGroups").getter(WebACL.getter(WebACL::postProcessFirewallManagerRuleGroups)).setter(WebACL.setter(Builder::postProcessFirewallManagerRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostProcessFirewallManagerRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallManagerRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MANAGED_BY_FIREWALL_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagedByFirewallManager").getter(WebACL.getter(WebACL::managedByFirewallManager)).setter(WebACL.setter(Builder::managedByFirewallManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedByFirewallManager").build()}).build();
    private static final SdkField<Map<String, CustomResponseBody>> CUSTOM_RESPONSE_BODIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomResponseBodies").getter(WebACL.getter(WebACL::customResponseBodies)).setter(WebACL.setter(Builder::customResponseBodies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomResponseBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, DEFAULT_ACTION_FIELD, DESCRIPTION_FIELD, RULES_FIELD, VISIBILITY_CONFIG_FIELD, CAPACITY_FIELD, PRE_PROCESS_FIREWALL_MANAGER_RULE_GROUPS_FIELD, POST_PROCESS_FIREWALL_MANAGER_RULE_GROUPS_FIELD, MANAGED_BY_FIREWALL_MANAGER_FIELD, CUSTOM_RESPONSE_BODIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final DefaultAction defaultAction;
    private final String description;
    private final List<Rule> rules;
    private final VisibilityConfig visibilityConfig;
    private final Long capacity;
    private final List<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups;
    private final List<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups;
    private final Boolean managedByFirewallManager;
    private final Map<String, CustomResponseBody> customResponseBodies;

    private WebACL(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.defaultAction = builder.defaultAction;
        this.description = builder.description;
        this.rules = builder.rules;
        this.visibilityConfig = builder.visibilityConfig;
        this.capacity = builder.capacity;
        this.preProcessFirewallManagerRuleGroups = builder.preProcessFirewallManagerRuleGroups;
        this.postProcessFirewallManagerRuleGroups = builder.postProcessFirewallManagerRuleGroups;
        this.managedByFirewallManager = builder.managedByFirewallManager;
        this.customResponseBodies = builder.customResponseBodies;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final VisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public final Long capacity() {
        return this.capacity;
    }

    public final boolean hasPreProcessFirewallManagerRuleGroups() {
        return this.preProcessFirewallManagerRuleGroups != null && !(this.preProcessFirewallManagerRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups() {
        return this.preProcessFirewallManagerRuleGroups;
    }

    public final boolean hasPostProcessFirewallManagerRuleGroups() {
        return this.postProcessFirewallManagerRuleGroups != null && !(this.postProcessFirewallManagerRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups() {
        return this.postProcessFirewallManagerRuleGroups;
    }

    public final Boolean managedByFirewallManager() {
        return this.managedByFirewallManager;
    }

    public final boolean hasCustomResponseBodies() {
        return this.customResponseBodies != null && !(this.customResponseBodies instanceof SdkAutoConstructMap);
    }

    public final Map<String, CustomResponseBody> customResponseBodies() {
        return this.customResponseBodies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreProcessFirewallManagerRuleGroups() ? this.preProcessFirewallManagerRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPostProcessFirewallManagerRuleGroups() ? this.postProcessFirewallManagerRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByFirewallManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomResponseBodies() ? this.customResponseBodies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACL)) {
            return false;
        }
        WebACL other = (WebACL)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.defaultAction(), other.defaultAction()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig()) && Objects.equals(this.capacity(), other.capacity()) && this.hasPreProcessFirewallManagerRuleGroups() == other.hasPreProcessFirewallManagerRuleGroups() && Objects.equals(this.preProcessFirewallManagerRuleGroups(), other.preProcessFirewallManagerRuleGroups()) && this.hasPostProcessFirewallManagerRuleGroups() == other.hasPostProcessFirewallManagerRuleGroups() && Objects.equals(this.postProcessFirewallManagerRuleGroups(), other.postProcessFirewallManagerRuleGroups()) && Objects.equals(this.managedByFirewallManager(), other.managedByFirewallManager()) && this.hasCustomResponseBodies() == other.hasCustomResponseBodies() && Objects.equals(this.customResponseBodies(), other.customResponseBodies());
    }

    public final String toString() {
        return ToString.builder((String)"WebACL").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("DefaultAction", (Object)this.defaultAction()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).add("VisibilityConfig", (Object)this.visibilityConfig()).add("Capacity", (Object)this.capacity()).add("PreProcessFirewallManagerRuleGroups", this.hasPreProcessFirewallManagerRuleGroups() ? this.preProcessFirewallManagerRuleGroups() : null).add("PostProcessFirewallManagerRuleGroups", this.hasPostProcessFirewallManagerRuleGroups() ? this.postProcessFirewallManagerRuleGroups() : null).add("ManagedByFirewallManager", (Object)this.managedByFirewallManager()).add("CustomResponseBodies", this.hasCustomResponseBodies() ? this.customResponseBodies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "PreProcessFirewallManagerRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.preProcessFirewallManagerRuleGroups()));
            }
            case "PostProcessFirewallManagerRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.postProcessFirewallManagerRuleGroups()));
            }
            case "ManagedByFirewallManager": {
                return Optional.ofNullable(clazz.cast(this.managedByFirewallManager()));
            }
            case "CustomResponseBodies": {
                return Optional.ofNullable(clazz.cast(this.customResponseBodies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebACL, T> g) {
        return obj -> g.apply((WebACL)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private DefaultAction defaultAction;
        private String description;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private VisibilityConfig visibilityConfig;
        private Long capacity;
        private List<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups = DefaultSdkAutoConstructList.getInstance();
        private List<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean managedByFirewallManager;
        private Map<String, CustomResponseBody> customResponseBodies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WebACL model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.defaultAction(model.defaultAction);
            this.description(model.description);
            this.rules(model.rules);
            this.visibilityConfig(model.visibilityConfig);
            this.capacity(model.capacity);
            this.preProcessFirewallManagerRuleGroups(model.preProcessFirewallManagerRuleGroups);
            this.postProcessFirewallManagerRuleGroups(model.postProcessFirewallManagerRuleGroups);
            this.managedByFirewallManager(model.managedByFirewallManager);
            this.customResponseBodies(model.customResponseBodies);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final DefaultAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(DefaultAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(DefaultAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Rule.Builder> getRules() {
            if (this.rules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        @Override
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        public final Long getCapacity() {
            return this.capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        public final Collection<FirewallManagerRuleGroup.Builder> getPreProcessFirewallManagerRuleGroups() {
            if (this.preProcessFirewallManagerRuleGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.preProcessFirewallManagerRuleGroups != null ? (Collection)this.preProcessFirewallManagerRuleGroups.stream().map(FirewallManagerRuleGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder preProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups) {
            this.preProcessFirewallManagerRuleGroups = FirewallManagerRuleGroupsCopier.copy(preProcessFirewallManagerRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preProcessFirewallManagerRuleGroups(FirewallManagerRuleGroup ... preProcessFirewallManagerRuleGroups) {
            this.preProcessFirewallManagerRuleGroups(Arrays.asList(preProcessFirewallManagerRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preProcessFirewallManagerRuleGroups(Consumer<FirewallManagerRuleGroup.Builder> ... preProcessFirewallManagerRuleGroups) {
            this.preProcessFirewallManagerRuleGroups(Stream.of(preProcessFirewallManagerRuleGroups).map(c -> (FirewallManagerRuleGroup)((FirewallManagerRuleGroup.Builder)FirewallManagerRuleGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPreProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup.BuilderImpl> preProcessFirewallManagerRuleGroups) {
            this.preProcessFirewallManagerRuleGroups = FirewallManagerRuleGroupsCopier.copyFromBuilder(preProcessFirewallManagerRuleGroups);
        }

        public final Collection<FirewallManagerRuleGroup.Builder> getPostProcessFirewallManagerRuleGroups() {
            if (this.postProcessFirewallManagerRuleGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.postProcessFirewallManagerRuleGroups != null ? (Collection)this.postProcessFirewallManagerRuleGroups.stream().map(FirewallManagerRuleGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder postProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups) {
            this.postProcessFirewallManagerRuleGroups = FirewallManagerRuleGroupsCopier.copy(postProcessFirewallManagerRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postProcessFirewallManagerRuleGroups(FirewallManagerRuleGroup ... postProcessFirewallManagerRuleGroups) {
            this.postProcessFirewallManagerRuleGroups(Arrays.asList(postProcessFirewallManagerRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postProcessFirewallManagerRuleGroups(Consumer<FirewallManagerRuleGroup.Builder> ... postProcessFirewallManagerRuleGroups) {
            this.postProcessFirewallManagerRuleGroups(Stream.of(postProcessFirewallManagerRuleGroups).map(c -> (FirewallManagerRuleGroup)((FirewallManagerRuleGroup.Builder)FirewallManagerRuleGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPostProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup.BuilderImpl> postProcessFirewallManagerRuleGroups) {
            this.postProcessFirewallManagerRuleGroups = FirewallManagerRuleGroupsCopier.copyFromBuilder(postProcessFirewallManagerRuleGroups);
        }

        public final Boolean getManagedByFirewallManager() {
            return this.managedByFirewallManager;
        }

        @Override
        public final Builder managedByFirewallManager(Boolean managedByFirewallManager) {
            this.managedByFirewallManager = managedByFirewallManager;
            return this;
        }

        public final void setManagedByFirewallManager(Boolean managedByFirewallManager) {
            this.managedByFirewallManager = managedByFirewallManager;
        }

        public final Map<String, CustomResponseBody.Builder> getCustomResponseBodies() {
            if (this.customResponseBodies instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customResponseBodies != null ? CollectionUtils.mapValues(this.customResponseBodies, CustomResponseBody::toBuilder) : null;
        }

        @Override
        public final Builder customResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copy(customResponseBodies);
            return this;
        }

        public final void setCustomResponseBodies(Map<String, CustomResponseBody.BuilderImpl> customResponseBodies) {
            this.customResponseBodies = CustomResponseBodiesCopier.copyFromBuilder(customResponseBodies);
        }

        public WebACL build() {
            return new WebACL(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebACL> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder defaultAction(DefaultAction var1);

        default public Builder defaultAction(Consumer<DefaultAction.Builder> defaultAction) {
            return this.defaultAction((DefaultAction)((DefaultAction.Builder)DefaultAction.builder().applyMutation(defaultAction)).build());
        }

        public Builder description(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder visibilityConfig(VisibilityConfig var1);

        default public Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return this.visibilityConfig((VisibilityConfig)((VisibilityConfig.Builder)VisibilityConfig.builder().applyMutation(visibilityConfig)).build());
        }

        public Builder capacity(Long var1);

        public Builder preProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> var1);

        public Builder preProcessFirewallManagerRuleGroups(FirewallManagerRuleGroup ... var1);

        public Builder preProcessFirewallManagerRuleGroups(Consumer<FirewallManagerRuleGroup.Builder> ... var1);

        public Builder postProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> var1);

        public Builder postProcessFirewallManagerRuleGroups(FirewallManagerRuleGroup ... var1);

        public Builder postProcessFirewallManagerRuleGroups(Consumer<FirewallManagerRuleGroup.Builder> ... var1);

        public Builder managedByFirewallManager(Boolean var1);

        public Builder customResponseBodies(Map<String, CustomResponseBody> var1);
    }
}

