/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ExcludedRule;
import software.amazon.awssdk.services.wafv2.model.ExcludedRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupReferenceStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupReferenceStatement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(RuleGroupReferenceStatement.getter(RuleGroupReferenceStatement::arn)).setter(RuleGroupReferenceStatement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<List<ExcludedRule>> EXCLUDED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedRules").getter(RuleGroupReferenceStatement.getter(RuleGroupReferenceStatement::excludedRules)).setter(RuleGroupReferenceStatement.setter(Builder::excludedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExcludedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, EXCLUDED_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<ExcludedRule> excludedRules;

    private RuleGroupReferenceStatement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.excludedRules = builder.excludedRules;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasExcludedRules() {
        return this.excludedRules != null && !(this.excludedRules instanceof SdkAutoConstructList);
    }

    public List<ExcludedRule> excludedRules() {
        return this.excludedRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedRules() ? this.excludedRules() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupReferenceStatement)) {
            return false;
        }
        RuleGroupReferenceStatement other = (RuleGroupReferenceStatement)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasExcludedRules() == other.hasExcludedRules() && Objects.equals(this.excludedRules(), other.excludedRules());
    }

    public String toString() {
        return ToString.builder((String)"RuleGroupReferenceStatement").add("ARN", (Object)this.arn()).add("ExcludedRules", this.hasExcludedRules() ? this.excludedRules() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ExcludedRules": {
                return Optional.ofNullable(clazz.cast(this.excludedRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupReferenceStatement, T> g) {
        return obj -> g.apply((RuleGroupReferenceStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<ExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupReferenceStatement model) {
            this.arn(model.arn);
            this.excludedRules(model.excludedRules);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<ExcludedRule.Builder> getExcludedRules() {
            if (this.excludedRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedRules != null ? (Collection)this.excludedRules.stream().map(ExcludedRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludedRules(Collection<ExcludedRule> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(ExcludedRule ... excludedRules) {
            this.excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<ExcludedRule.Builder> ... excludedRules) {
            this.excludedRules(Stream.of(excludedRules).map(c -> (ExcludedRule)((ExcludedRule.Builder)ExcludedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludedRules(Collection<ExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copyFromBuilder(excludedRules);
        }

        public RuleGroupReferenceStatement build() {
            return new RuleGroupReferenceStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupReferenceStatement> {
        public Builder arn(String var1);

        public Builder excludedRules(Collection<ExcludedRule> var1);

        public Builder excludedRules(ExcludedRule ... var1);

        public Builder excludedRules(Consumer<ExcludedRule.Builder> ... var1);
    }
}

