/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.CountryCode;
import software.amazon.awssdk.services.wafv2.model.CountryCodesCopier;
import software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoMatchStatement> {
    private static final SdkField<List<String>> COUNTRY_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CountryCodes").getter(GeoMatchStatement.getter(GeoMatchStatement::countryCodesAsStrings)).setter(GeoMatchStatement.setter(Builder::countryCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ForwardedIPConfig> FORWARDED_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardedIPConfig").getter(GeoMatchStatement.getter(GeoMatchStatement::forwardedIPConfig)).setter(GeoMatchStatement.setter(Builder::forwardedIPConfig)).constructor(ForwardedIPConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIPConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODES_FIELD, FORWARDED_IP_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> countryCodes;
    private final ForwardedIPConfig forwardedIPConfig;

    private GeoMatchStatement(BuilderImpl builder) {
        this.countryCodes = builder.countryCodes;
        this.forwardedIPConfig = builder.forwardedIPConfig;
    }

    public List<CountryCode> countryCodes() {
        return CountryCodesCopier.copyStringToEnum(this.countryCodes);
    }

    public boolean hasCountryCodes() {
        return this.countryCodes != null && !(this.countryCodes instanceof SdkAutoConstructList);
    }

    public List<String> countryCodesAsStrings() {
        return this.countryCodes;
    }

    public ForwardedIPConfig forwardedIPConfig() {
        return this.forwardedIPConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCodesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedIPConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchStatement)) {
            return false;
        }
        GeoMatchStatement other = (GeoMatchStatement)obj;
        return Objects.equals(this.countryCodesAsStrings(), other.countryCodesAsStrings()) && Objects.equals(this.forwardedIPConfig(), other.forwardedIPConfig());
    }

    public String toString() {
        return ToString.builder((String)"GeoMatchStatement").add("CountryCodes", this.countryCodesAsStrings()).add("ForwardedIPConfig", (Object)this.forwardedIPConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountryCodes": {
                return Optional.ofNullable(clazz.cast(this.countryCodesAsStrings()));
            }
            case "ForwardedIPConfig": {
                return Optional.ofNullable(clazz.cast(this.forwardedIPConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchStatement, T> g) {
        return obj -> g.apply((GeoMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> countryCodes = DefaultSdkAutoConstructList.getInstance();
        private ForwardedIPConfig forwardedIPConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchStatement model) {
            this.countryCodesWithStrings(model.countryCodes);
            this.forwardedIPConfig(model.forwardedIPConfig);
        }

        public final Collection<String> getCountryCodes() {
            return this.countryCodes;
        }

        @Override
        public final Builder countryCodesWithStrings(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodesWithStrings(String ... countryCodes) {
            this.countryCodesWithStrings(Arrays.asList(countryCodes));
            return this;
        }

        @Override
        public final Builder countryCodes(Collection<CountryCode> countryCodes) {
            this.countryCodes = CountryCodesCopier.copyEnumToString(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodes(CountryCode ... countryCodes) {
            this.countryCodes(Arrays.asList(countryCodes));
            return this;
        }

        public final void setCountryCodes(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
        }

        public final ForwardedIPConfig.Builder getForwardedIPConfig() {
            return this.forwardedIPConfig != null ? this.forwardedIPConfig.toBuilder() : null;
        }

        @Override
        public final Builder forwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig;
            return this;
        }

        public final void setForwardedIPConfig(ForwardedIPConfig.BuilderImpl forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig != null ? forwardedIPConfig.build() : null;
        }

        public GeoMatchStatement build() {
            return new GeoMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoMatchStatement> {
        public Builder countryCodesWithStrings(Collection<String> var1);

        public Builder countryCodesWithStrings(String ... var1);

        public Builder countryCodes(Collection<CountryCode> var1);

        public Builder countryCodes(CountryCode ... var1);

        public Builder forwardedIPConfig(ForwardedIPConfig var1);

        default public Builder forwardedIPConfig(Consumer<ForwardedIPConfig.Builder> forwardedIPConfig) {
            return this.forwardedIPConfig((ForwardedIPConfig)((ForwardedIPConfig.Builder)ForwardedIPConfig.builder().applyMutation(forwardedIPConfig)).build());
        }
    }
}

