/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.RegexMatchTuple;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexMatchSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegexMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegexMatchSetUpdate.getter(RegexMatchSetUpdate::actionAsString)).setter(RegexMatchSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<RegexMatchTuple> REGEX_MATCH_TUPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RegexMatchSetUpdate.getter(RegexMatchSetUpdate::regexMatchTuple)).setter(RegexMatchSetUpdate.setter(Builder::regexMatchTuple)).constructor(RegexMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchTuple").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, REGEX_MATCH_TUPLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final RegexMatchTuple regexMatchTuple;

    private RegexMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.regexMatchTuple = builder.regexMatchTuple;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public RegexMatchTuple regexMatchTuple() {
        return this.regexMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchTuple());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSetUpdate)) {
            return false;
        }
        RegexMatchSetUpdate other = (RegexMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.regexMatchTuple(), other.regexMatchTuple());
    }

    public String toString() {
        return ToString.builder((String)"RegexMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("RegexMatchTuple", (Object)this.regexMatchTuple()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "RegexMatchTuple": {
                return Optional.ofNullable(clazz.cast(this.regexMatchTuple()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexMatchSetUpdate, T> g) {
        return obj -> g.apply((RegexMatchSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private RegexMatchTuple regexMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSetUpdate model) {
            this.action(model.action);
            this.regexMatchTuple(model.regexMatchTuple);
        }

        public final String getActionAsString() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final RegexMatchTuple.Builder getRegexMatchTuple() {
            return this.regexMatchTuple != null ? this.regexMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder regexMatchTuple(RegexMatchTuple regexMatchTuple) {
            this.regexMatchTuple = regexMatchTuple;
            return this;
        }

        public final void setRegexMatchTuple(RegexMatchTuple.BuilderImpl regexMatchTuple) {
            this.regexMatchTuple = regexMatchTuple != null ? regexMatchTuple.build() : null;
        }

        public RegexMatchSetUpdate build() {
            return new RegexMatchSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegexMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder regexMatchTuple(RegexMatchTuple var1);

        default public Builder regexMatchTuple(Consumer<RegexMatchTuple.Builder> regexMatchTuple) {
            return this.regexMatchTuple((RegexMatchTuple)((RegexMatchTuple.Builder)RegexMatchTuple.builder().applyMutation(regexMatchTuple)).build());
        }
    }
}

