/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.Predicate;
import software.amazon.awssdk.services.waf.model.PredicatesCopier;
import software.amazon.awssdk.services.waf.model.RateKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RateBasedRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RateBasedRule> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RateBasedRule.getter(RateBasedRule::ruleId)).setter(RateBasedRule.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RateBasedRule.getter(RateBasedRule::name)).setter(RateBasedRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RateBasedRule.getter(RateBasedRule::metricName)).setter(RateBasedRule.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<Predicate>> MATCH_PREDICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RateBasedRule.getter(RateBasedRule::matchPredicates)).setter(RateBasedRule.setter(Builder::matchPredicates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPredicates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RateBasedRule.getter(RateBasedRule::rateKeyAsString)).setter(RateBasedRule.setter(Builder::rateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateKey").build()}).build();
    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(RateBasedRule.getter(RateBasedRule::rateLimit)).setter(RateBasedRule.setter(Builder::rateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, NAME_FIELD, METRIC_NAME_FIELD, MATCH_PREDICATES_FIELD, RATE_KEY_FIELD, RATE_LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleId;
    private final String name;
    private final String metricName;
    private final List<Predicate> matchPredicates;
    private final String rateKey;
    private final Long rateLimit;

    private RateBasedRule(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.matchPredicates = builder.matchPredicates;
        this.rateKey = builder.rateKey;
        this.rateLimit = builder.rateLimit;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Predicate> matchPredicates() {
        return this.matchPredicates;
    }

    public RateKey rateKey() {
        return RateKey.fromValue(this.rateKey);
    }

    public String rateKeyAsString() {
        return this.rateKey;
    }

    public Long rateLimit() {
        return this.rateLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchPredicates());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedRule)) {
            return false;
        }
        RateBasedRule other = (RateBasedRule)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.matchPredicates(), other.matchPredicates()) && Objects.equals(this.rateKeyAsString(), other.rateKeyAsString()) && Objects.equals(this.rateLimit(), other.rateLimit());
    }

    public String toString() {
        return ToString.builder((String)"RateBasedRule").add("RuleId", (Object)this.ruleId()).add("Name", (Object)this.name()).add("MetricName", (Object)this.metricName()).add("MatchPredicates", this.matchPredicates()).add("RateKey", (Object)this.rateKeyAsString()).add("RateLimit", (Object)this.rateLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "MatchPredicates": {
                return Optional.ofNullable(clazz.cast(this.matchPredicates()));
            }
            case "RateKey": {
                return Optional.ofNullable(clazz.cast(this.rateKeyAsString()));
            }
            case "RateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RateBasedRule, T> g) {
        return obj -> g.apply((RateBasedRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String name;
        private String metricName;
        private List<Predicate> matchPredicates = DefaultSdkAutoConstructList.getInstance();
        private String rateKey;
        private Long rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedRule model) {
            this.ruleId(model.ruleId);
            this.name(model.name);
            this.metricName(model.metricName);
            this.matchPredicates(model.matchPredicates);
            this.rateKey(model.rateKey);
            this.rateLimit(model.rateLimit);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Predicate.Builder> getMatchPredicates() {
            return this.matchPredicates != null ? (Collection)this.matchPredicates.stream().map(Predicate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matchPredicates(Collection<Predicate> matchPredicates) {
            this.matchPredicates = PredicatesCopier.copy(matchPredicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(Predicate ... matchPredicates) {
            this.matchPredicates(Arrays.asList(matchPredicates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(Consumer<Predicate.Builder> ... matchPredicates) {
            this.matchPredicates(Stream.of(matchPredicates).map(c -> (Predicate)((Predicate.Builder)Predicate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMatchPredicates(Collection<Predicate.BuilderImpl> matchPredicates) {
            this.matchPredicates = PredicatesCopier.copyFromBuilder(matchPredicates);
        }

        public final String getRateKeyAsString() {
            return this.rateKey;
        }

        @Override
        public final Builder rateKey(String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        @Override
        public final Builder rateKey(RateKey rateKey) {
            this.rateKey(rateKey.toString());
            return this;
        }

        public final void setRateKey(String rateKey) {
            this.rateKey = rateKey;
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        public RateBasedRule build() {
            return new RateBasedRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RateBasedRule> {
        public Builder ruleId(String var1);

        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder matchPredicates(Collection<Predicate> var1);

        public Builder matchPredicates(Predicate ... var1);

        public Builder matchPredicates(Consumer<Predicate.Builder> ... var1);

        public Builder rateKey(String var1);

        public Builder rateKey(RateKey var1);

        public Builder rateLimit(Long var1);
    }
}

