/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePermissionPolicyRequest
extends WafRequest
implements ToCopyableBuilder<Builder, DeletePermissionPolicyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeletePermissionPolicyRequest.getter(DeletePermissionPolicyRequest::resourceArn)).setter(DeletePermissionPolicyRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD));
    private final String resourceArn;

    private DeletePermissionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePermissionPolicyRequest)) {
            return false;
        }
        DeletePermissionPolicyRequest other = (DeletePermissionPolicyRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public String toString() {
        return ToString.builder((String)"DeletePermissionPolicyRequest").add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePermissionPolicyRequest, T> g) {
        return obj -> g.apply((DeletePermissionPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePermissionPolicyRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePermissionPolicyRequest build() {
            return new DeletePermissionPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePermissionPolicyRequest> {
        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

