/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSqlInjectionMatchSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSqlInjectionMatchSetsResponse.getter(ListSqlInjectionMatchSetsResponse::nextMarker)).setter(ListSqlInjectionMatchSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<SqlInjectionMatchSetSummary>> SQL_INJECTION_MATCH_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSqlInjectionMatchSetsResponse.getter(ListSqlInjectionMatchSetsResponse::sqlInjectionMatchSets)).setter(ListSqlInjectionMatchSetsResponse.setter(Builder::sqlInjectionMatchSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlInjectionMatchSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, SQL_INJECTION_MATCH_SETS_FIELD));
    private final String nextMarker;
    private final List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets;

    private ListSqlInjectionMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.sqlInjectionMatchSets = builder.sqlInjectionMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets() {
        return this.sqlInjectionMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSqlInjectionMatchSetsResponse)) {
            return false;
        }
        ListSqlInjectionMatchSetsResponse other = (ListSqlInjectionMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.sqlInjectionMatchSets(), other.sqlInjectionMatchSets());
    }

    public String toString() {
        return ToString.builder((String)"ListSqlInjectionMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("SqlInjectionMatchSets", this.sqlInjectionMatchSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "SqlInjectionMatchSets": {
                return Optional.ofNullable(clazz.cast(this.sqlInjectionMatchSets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSqlInjectionMatchSetsResponse, T> g) {
        return obj -> g.apply((ListSqlInjectionMatchSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSqlInjectionMatchSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.sqlInjectionMatchSets(model.sqlInjectionMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SqlInjectionMatchSetSummary.Builder> getSqlInjectionMatchSets() {
            return this.sqlInjectionMatchSets != null ? (Collection)this.sqlInjectionMatchSets.stream().map(SqlInjectionMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copy(sqlInjectionMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets(Arrays.asList(sqlInjectionMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchSets(Consumer<SqlInjectionMatchSetSummary.Builder> ... sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets(Stream.of(sqlInjectionMatchSets).map(c -> (SqlInjectionMatchSetSummary)((SqlInjectionMatchSetSummary.Builder)SqlInjectionMatchSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary.BuilderImpl> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copyFromBuilder(sqlInjectionMatchSets);
        }

        @Override
        public ListSqlInjectionMatchSetsResponse build() {
            return new ListSqlInjectionMatchSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> var1);

        public Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... var1);

        public Builder sqlInjectionMatchSets(Consumer<SqlInjectionMatchSetSummary.Builder> ... var1);
    }
}

