/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebAclMigrationStackRequest
extends WafRequest
implements ToCopyableBuilder<Builder, CreateWebAclMigrationStackRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLId").getter(CreateWebAclMigrationStackRequest.getter(CreateWebAclMigrationStackRequest::webACLId)).setter(CreateWebAclMigrationStackRequest.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CreateWebAclMigrationStackRequest.getter(CreateWebAclMigrationStackRequest::s3BucketName)).setter(CreateWebAclMigrationStackRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<Boolean> IGNORE_UNSUPPORTED_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnoreUnsupportedType").getter(CreateWebAclMigrationStackRequest.getter(CreateWebAclMigrationStackRequest::ignoreUnsupportedType)).setter(CreateWebAclMigrationStackRequest.setter(Builder::ignoreUnsupportedType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreUnsupportedType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD, S3_BUCKET_NAME_FIELD, IGNORE_UNSUPPORTED_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWebAclMigrationStackRequest.memberNameToFieldInitializer();
    private final String webACLId;
    private final String s3BucketName;
    private final Boolean ignoreUnsupportedType;

    private CreateWebAclMigrationStackRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.s3BucketName = builder.s3BucketName;
        this.ignoreUnsupportedType = builder.ignoreUnsupportedType;
    }

    public final String webACLId() {
        return this.webACLId;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final Boolean ignoreUnsupportedType() {
        return this.ignoreUnsupportedType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreUnsupportedType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebAclMigrationStackRequest)) {
            return false;
        }
        CreateWebAclMigrationStackRequest other = (CreateWebAclMigrationStackRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.ignoreUnsupportedType(), other.ignoreUnsupportedType());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWebAclMigrationStackRequest").add("WebACLId", (Object)this.webACLId()).add("S3BucketName", (Object)this.s3BucketName()).add("IgnoreUnsupportedType", (Object)this.ignoreUnsupportedType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "IgnoreUnsupportedType": {
                return Optional.ofNullable(clazz.cast(this.ignoreUnsupportedType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("IgnoreUnsupportedType", IGNORE_UNSUPPORTED_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWebAclMigrationStackRequest, T> g) {
        return obj -> g.apply((CreateWebAclMigrationStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String s3BucketName;
        private Boolean ignoreUnsupportedType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebAclMigrationStackRequest model) {
            super(model);
            this.webACLId(model.webACLId);
            this.s3BucketName(model.s3BucketName);
            this.ignoreUnsupportedType(model.ignoreUnsupportedType);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Boolean getIgnoreUnsupportedType() {
            return this.ignoreUnsupportedType;
        }

        public final void setIgnoreUnsupportedType(Boolean ignoreUnsupportedType) {
            this.ignoreUnsupportedType = ignoreUnsupportedType;
        }

        @Override
        public final Builder ignoreUnsupportedType(Boolean ignoreUnsupportedType) {
            this.ignoreUnsupportedType = ignoreUnsupportedType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebAclMigrationStackRequest build() {
            return new CreateWebAclMigrationStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebAclMigrationStackRequest> {
        public Builder webACLId(String var1);

        public Builder s3BucketName(String var1);

        public Builder ignoreUnsupportedType(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

