/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateWebAclRequest
extends WafRequest
implements ToCopyableBuilder<Builder, AssociateWebAclRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLId").getter(AssociateWebAclRequest.getter(AssociateWebAclRequest::webACLId)).setter(AssociateWebAclRequest.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(AssociateWebAclRequest.getter(AssociateWebAclRequest::resourceArn)).setter(AssociateWebAclRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateWebAclRequest.memberNameToFieldInitializer();
    private final String webACLId;
    private final String resourceArn;

    private AssociateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.resourceArn = builder.resourceArn;
    }

    public final String webACLId() {
        return this.webACLId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebAclRequest)) {
            return false;
        }
        AssociateWebAclRequest other = (AssociateWebAclRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateWebAclRequest").add("WebACLId", (Object)this.webACLId()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateWebAclRequest, T> g) {
        return obj -> g.apply((AssociateWebAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebAclRequest model) {
            super(model);
            this.webACLId(model.webACLId);
            this.resourceArn(model.resourceArn);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWebAclRequest build() {
            return new AssociateWebAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateWebAclRequest> {
        public Builder webACLId(String var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

