/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MatchFieldType {
    URI("URI"),
    QUERY_STRING("QUERY_STRING"),
    HEADER("HEADER"),
    METHOD("METHOD"),
    BODY("BODY"),
    SINGLE_QUERY_ARG("SINGLE_QUERY_ARG"),
    ALL_QUERY_ARGS("ALL_QUERY_ARGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MatchFieldType> VALUE_MAP;
    private final String value;

    private MatchFieldType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MatchFieldType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MatchFieldType> knownValues() {
        EnumSet<MatchFieldType> knownValues = EnumSet.allOf(MatchFieldType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MatchFieldType.class, MatchFieldType::toString);
    }
}

