/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.Predicate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(RuleUpdate.getter(RuleUpdate::actionAsString)).setter(RuleUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Predicate").getter(RuleUpdate.getter(RuleUpdate::predicate)).setter(RuleUpdate.setter(Builder::predicate)).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, PREDICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final Predicate predicate;

    private RuleUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.predicate = builder.predicate;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Predicate predicate() {
        return this.predicate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleUpdate)) {
            return false;
        }
        RuleUpdate other = (RuleUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.predicate(), other.predicate());
    }

    public final String toString() {
        return ToString.builder((String)"RuleUpdate").add("Action", (Object)this.actionAsString()).add("Predicate", (Object)this.predicate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Predicate": {
                return Optional.ofNullable(clazz.cast(this.predicate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("Predicate", PREDICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleUpdate, T> g) {
        return obj -> g.apply((RuleUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Predicate predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleUpdate model) {
            this.action(model.action);
            this.predicate(model.predicate);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public RuleUpdate build() {
            return new RuleUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().applyMutation(predicate)).build());
        }
    }
}

