/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RuleUpdate;
import software.amazon.awssdk.services.waf.model.RuleUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRateBasedRuleRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(UpdateRateBasedRuleRequest.getter(UpdateRateBasedRuleRequest::ruleId)).setter(UpdateRateBasedRuleRequest.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(UpdateRateBasedRuleRequest.getter(UpdateRateBasedRuleRequest::changeToken)).setter(UpdateRateBasedRuleRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<RuleUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateRateBasedRuleRequest.getter(UpdateRateBasedRuleRequest::updates)).setter(UpdateRateBasedRuleRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RateLimit").getter(UpdateRateBasedRuleRequest.getter(UpdateRateBasedRuleRequest::rateLimit)).setter(UpdateRateBasedRuleRequest.setter(Builder::rateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD, RATE_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RuleId", RULE_ID_FIELD);
            this.put("ChangeToken", CHANGE_TOKEN_FIELD);
            this.put("Updates", UPDATES_FIELD);
            this.put("RateLimit", RATE_LIMIT_FIELD);
        }
    });
    private final String ruleId;
    private final String changeToken;
    private final List<RuleUpdate> updates;
    private final Long rateLimit;

    private UpdateRateBasedRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.rateLimit = builder.rateLimit;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<RuleUpdate> updates() {
        return this.updates;
    }

    public final Long rateLimit() {
        return this.rateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRateBasedRuleRequest)) {
            return false;
        }
        UpdateRateBasedRuleRequest other = (UpdateRateBasedRuleRequest)((Object)obj);
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.rateLimit(), other.rateLimit());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRateBasedRuleRequest").add("RuleId", (Object)this.ruleId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.hasUpdates() ? this.updates() : null).add("RateLimit", (Object)this.rateLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "RateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRateBasedRuleRequest, T> g) {
        return obj -> g.apply((UpdateRateBasedRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String ruleId;
        private String changeToken;
        private List<RuleUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private Long rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRateBasedRuleRequest model) {
            super(model);
            this.ruleId(model.ruleId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
            this.rateLimit(model.rateLimit);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final List<RuleUpdate.Builder> getUpdates() {
            List<RuleUpdate.Builder> result = RuleUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<RuleUpdate.BuilderImpl> updates) {
            this.updates = RuleUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<RuleUpdate> updates) {
            this.updates = RuleUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RuleUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RuleUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (RuleUpdate)((RuleUpdate.Builder)RuleUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRateBasedRuleRequest build() {
            return new UpdateRateBasedRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRateBasedRuleRequest> {
        public Builder ruleId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<RuleUpdate> var1);

        public Builder updates(RuleUpdate ... var1);

        public Builder updates(Consumer<RuleUpdate.Builder> ... var1);

        public Builder rateLimit(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

