/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSqlInjectionMatchSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListSqlInjectionMatchSetsResponse.getter(ListSqlInjectionMatchSetsResponse::nextMarker)).setter(ListSqlInjectionMatchSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<SqlInjectionMatchSetSummary>> SQL_INJECTION_MATCH_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SqlInjectionMatchSets").getter(ListSqlInjectionMatchSetsResponse.getter(ListSqlInjectionMatchSetsResponse::sqlInjectionMatchSets)).setter(ListSqlInjectionMatchSetsResponse.setter(Builder::sqlInjectionMatchSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SqlInjectionMatchSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, SQL_INJECTION_MATCH_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextMarker", NEXT_MARKER_FIELD);
            this.put("SqlInjectionMatchSets", SQL_INJECTION_MATCH_SETS_FIELD);
        }
    });
    private final String nextMarker;
    private final List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets;

    private ListSqlInjectionMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.sqlInjectionMatchSets = builder.sqlInjectionMatchSets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasSqlInjectionMatchSets() {
        return this.sqlInjectionMatchSets != null && !(this.sqlInjectionMatchSets instanceof SdkAutoConstructList);
    }

    public final List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets() {
        return this.sqlInjectionMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSqlInjectionMatchSets() ? this.sqlInjectionMatchSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSqlInjectionMatchSetsResponse)) {
            return false;
        }
        ListSqlInjectionMatchSetsResponse other = (ListSqlInjectionMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasSqlInjectionMatchSets() == other.hasSqlInjectionMatchSets() && Objects.equals(this.sqlInjectionMatchSets(), other.sqlInjectionMatchSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListSqlInjectionMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("SqlInjectionMatchSets", this.hasSqlInjectionMatchSets() ? this.sqlInjectionMatchSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "SqlInjectionMatchSets": {
                return Optional.ofNullable(clazz.cast(this.sqlInjectionMatchSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSqlInjectionMatchSetsResponse, T> g) {
        return obj -> g.apply((ListSqlInjectionMatchSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SqlInjectionMatchSetSummary> sqlInjectionMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSqlInjectionMatchSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.sqlInjectionMatchSets(model.sqlInjectionMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<SqlInjectionMatchSetSummary.Builder> getSqlInjectionMatchSets() {
            List<SqlInjectionMatchSetSummary.Builder> result = SqlInjectionMatchSetSummariesCopier.copyToBuilder(this.sqlInjectionMatchSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary.BuilderImpl> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copyFromBuilder(sqlInjectionMatchSets);
        }

        @Override
        public final Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets = SqlInjectionMatchSetSummariesCopier.copy(sqlInjectionMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets(Arrays.asList(sqlInjectionMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchSets(Consumer<SqlInjectionMatchSetSummary.Builder> ... sqlInjectionMatchSets) {
            this.sqlInjectionMatchSets(Stream.of(sqlInjectionMatchSets).map(c -> (SqlInjectionMatchSetSummary)((SqlInjectionMatchSetSummary.Builder)SqlInjectionMatchSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSqlInjectionMatchSetsResponse build() {
            return new ListSqlInjectionMatchSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSqlInjectionMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sqlInjectionMatchSets(Collection<SqlInjectionMatchSetSummary> var1);

        public Builder sqlInjectionMatchSets(SqlInjectionMatchSetSummary ... var1);

        public Builder sqlInjectionMatchSets(Consumer<SqlInjectionMatchSetSummary.Builder> ... var1);
    }
}

