/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.regional;

import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.waf.regional.auth.scheme.WafRegionalAuthSchemeProvider;
import software.amazon.awssdk.services.waf.regional.internal.WafRegionalServiceClientConfigurationBuilder;

@SdkPublicApi
public final class WafRegionalServiceClientConfiguration
extends AwsServiceClientConfiguration {
    private final WafRegionalAuthSchemeProvider authSchemeProvider;

    public WafRegionalServiceClientConfiguration(Builder builder) {
        super((AwsServiceClientConfiguration.Builder)builder);
        this.authSchemeProvider = builder.authSchemeProvider();
    }

    public static Builder builder() {
        return new WafRegionalServiceClientConfigurationBuilder();
    }

    public WafRegionalAuthSchemeProvider authSchemeProvider() {
        return this.authSchemeProvider;
    }

    public static interface Builder
    extends AwsServiceClientConfiguration.Builder {
        public Builder overrideConfiguration(ClientOverrideConfiguration var1);

        public ClientOverrideConfiguration overrideConfiguration();

        public Builder endpointOverride(URI var1);

        public URI endpointOverride();

        public Builder endpointProvider(EndpointProvider var1);

        public EndpointProvider endpointProvider();

        public Builder region(Region var1);

        public Region region();

        public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> var1);

        public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider();

        public Builder putAuthScheme(AuthScheme<?> var1);

        public Map<String, AuthScheme<?>> authSchemes();

        public Builder authSchemeProvider(WafRegionalAuthSchemeProvider var1);

        public WafRegionalAuthSchemeProvider authSchemeProvider();

        public WafRegionalServiceClientConfiguration build();
    }
}

