/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.waf.DefaultWafBaseClientBuilder;
import software.amazon.awssdk.services.waf.DefaultWafClient;
import software.amazon.awssdk.services.waf.WafClient;
import software.amazon.awssdk.services.waf.WafClientBuilder;
import software.amazon.awssdk.services.waf.WafServiceClientConfiguration;
import software.amazon.awssdk.services.waf.endpoints.WafEndpointProvider;

@SdkInternalApi
final class DefaultWafClientBuilder
extends DefaultWafBaseClientBuilder<WafClientBuilder, WafClient>
implements WafClientBuilder {
    DefaultWafClientBuilder() {
    }

    @Override
    public DefaultWafClientBuilder endpointProvider(WafEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WafClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWafClientBuilder.validateClientOptions(clientConfiguration);
        WafServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWafClient client = new DefaultWafClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WafServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WafServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

