/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.services.waf.model.IPSetDescriptorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPSet> {
    private static final SdkField<String> IP_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPSetId").getter(IPSet.getter(IPSet::ipSetId)).setter(IPSet.setter(Builder::ipSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(IPSet.getter(IPSet::name)).setter(IPSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<IPSetDescriptor>> IP_SET_DESCRIPTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IPSetDescriptors").getter(IPSet.getter(IPSet::ipSetDescriptors)).setter(IPSet.setter(Builder::ipSetDescriptors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetDescriptors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPSetDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_ID_FIELD, NAME_FIELD, IP_SET_DESCRIPTORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipSetId;
    private final String name;
    private final List<IPSetDescriptor> ipSetDescriptors;

    private IPSet(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
        this.ipSetDescriptors = builder.ipSetDescriptors;
    }

    public final String ipSetId() {
        return this.ipSetId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasIpSetDescriptors() {
        return this.ipSetDescriptors != null && !(this.ipSetDescriptors instanceof SdkAutoConstructList);
    }

    public final List<IPSetDescriptor> ipSetDescriptors() {
        return this.ipSetDescriptors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpSetDescriptors() ? this.ipSetDescriptors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        return Objects.equals(this.ipSetId(), other.ipSetId()) && Objects.equals(this.name(), other.name()) && this.hasIpSetDescriptors() == other.hasIpSetDescriptors() && Objects.equals(this.ipSetDescriptors(), other.ipSetDescriptors());
    }

    public final String toString() {
        return ToString.builder((String)"IPSet").add("IPSetId", (Object)this.ipSetId()).add("Name", (Object)this.name()).add("IPSetDescriptors", this.hasIpSetDescriptors() ? this.ipSetDescriptors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSetId": {
                return Optional.ofNullable(clazz.cast(this.ipSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IPSetDescriptors": {
                return Optional.ofNullable(clazz.cast(this.ipSetDescriptors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSet, T> g) {
        return obj -> g.apply((IPSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String name;
        private List<IPSetDescriptor> ipSetDescriptors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IPSet model) {
            this.ipSetId(model.ipSetId);
            this.name(model.name);
            this.ipSetDescriptors(model.ipSetDescriptors);
        }

        public final String getIpSetId() {
            return this.ipSetId;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<IPSetDescriptor.Builder> getIpSetDescriptors() {
            List<IPSetDescriptor.Builder> result = IPSetDescriptorsCopier.copyToBuilder(this.ipSetDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpSetDescriptors(Collection<IPSetDescriptor.BuilderImpl> ipSetDescriptors) {
            this.ipSetDescriptors = IPSetDescriptorsCopier.copyFromBuilder(ipSetDescriptors);
        }

        @Override
        public final Builder ipSetDescriptors(Collection<IPSetDescriptor> ipSetDescriptors) {
            this.ipSetDescriptors = IPSetDescriptorsCopier.copy(ipSetDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSetDescriptors(IPSetDescriptor ... ipSetDescriptors) {
            this.ipSetDescriptors(Arrays.asList(ipSetDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSetDescriptors(Consumer<IPSetDescriptor.Builder> ... ipSetDescriptors) {
            this.ipSetDescriptors(Stream.of(ipSetDescriptors).map(c -> (IPSetDescriptor)((IPSetDescriptor.Builder)IPSetDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IPSet build() {
            return new IPSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPSet> {
        public Builder ipSetId(String var1);

        public Builder name(String var1);

        public Builder ipSetDescriptors(Collection<IPSetDescriptor> var1);

        public Builder ipSetDescriptors(IPSetDescriptor ... var1);

        public Builder ipSetDescriptors(Consumer<IPSetDescriptor.Builder> ... var1);
    }
}

