/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.waf.WafClient;
import software.amazon.awssdk.services.waf.WafServiceClientConfiguration;
import software.amazon.awssdk.services.waf.model.CreateByteMatchSetRequest;
import software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse;
import software.amazon.awssdk.services.waf.model.CreateGeoMatchSetRequest;
import software.amazon.awssdk.services.waf.model.CreateGeoMatchSetResponse;
import software.amazon.awssdk.services.waf.model.CreateIpSetRequest;
import software.amazon.awssdk.services.waf.model.CreateIpSetResponse;
import software.amazon.awssdk.services.waf.model.CreateRateBasedRuleRequest;
import software.amazon.awssdk.services.waf.model.CreateRateBasedRuleResponse;
import software.amazon.awssdk.services.waf.model.CreateRegexMatchSetRequest;
import software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse;
import software.amazon.awssdk.services.waf.model.CreateRegexPatternSetRequest;
import software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse;
import software.amazon.awssdk.services.waf.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.waf.model.CreateRuleRequest;
import software.amazon.awssdk.services.waf.model.CreateRuleResponse;
import software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetRequest;
import software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse;
import software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetRequest;
import software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse;
import software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackRequest;
import software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackResponse;
import software.amazon.awssdk.services.waf.model.CreateWebAclRequest;
import software.amazon.awssdk.services.waf.model.CreateWebAclResponse;
import software.amazon.awssdk.services.waf.model.CreateXssMatchSetRequest;
import software.amazon.awssdk.services.waf.model.CreateXssMatchSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteByteMatchSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteByteMatchSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.waf.model.DeletePermissionPolicyRequest;
import software.amazon.awssdk.services.waf.model.DeletePermissionPolicyResponse;
import software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleRequest;
import software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleResponse;
import software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.waf.model.DeleteRuleRequest;
import software.amazon.awssdk.services.waf.model.DeleteRuleResponse;
import software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetResponse;
import software.amazon.awssdk.services.waf.model.DeleteWebAclRequest;
import software.amazon.awssdk.services.waf.model.DeleteWebAclResponse;
import software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest;
import software.amazon.awssdk.services.waf.model.DeleteXssMatchSetResponse;
import software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest;
import software.amazon.awssdk.services.waf.model.GetByteMatchSetResponse;
import software.amazon.awssdk.services.waf.model.GetChangeTokenRequest;
import software.amazon.awssdk.services.waf.model.GetChangeTokenResponse;
import software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest;
import software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse;
import software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest;
import software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse;
import software.amazon.awssdk.services.waf.model.GetIpSetRequest;
import software.amazon.awssdk.services.waf.model.GetIpSetResponse;
import software.amazon.awssdk.services.waf.model.GetLoggingConfigurationRequest;
import software.amazon.awssdk.services.waf.model.GetLoggingConfigurationResponse;
import software.amazon.awssdk.services.waf.model.GetPermissionPolicyRequest;
import software.amazon.awssdk.services.waf.model.GetPermissionPolicyResponse;
import software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysRequest;
import software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysResponse;
import software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest;
import software.amazon.awssdk.services.waf.model.GetRateBasedRuleResponse;
import software.amazon.awssdk.services.waf.model.GetRegexMatchSetRequest;
import software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse;
import software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest;
import software.amazon.awssdk.services.waf.model.GetRegexPatternSetResponse;
import software.amazon.awssdk.services.waf.model.GetRuleGroupRequest;
import software.amazon.awssdk.services.waf.model.GetRuleGroupResponse;
import software.amazon.awssdk.services.waf.model.GetRuleRequest;
import software.amazon.awssdk.services.waf.model.GetRuleResponse;
import software.amazon.awssdk.services.waf.model.GetSampledRequestsRequest;
import software.amazon.awssdk.services.waf.model.GetSampledRequestsResponse;
import software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest;
import software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse;
import software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetRequest;
import software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse;
import software.amazon.awssdk.services.waf.model.GetWebAclRequest;
import software.amazon.awssdk.services.waf.model.GetWebAclResponse;
import software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest;
import software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse;
import software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest;
import software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse;
import software.amazon.awssdk.services.waf.model.ListByteMatchSetsRequest;
import software.amazon.awssdk.services.waf.model.ListByteMatchSetsResponse;
import software.amazon.awssdk.services.waf.model.ListGeoMatchSetsRequest;
import software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse;
import software.amazon.awssdk.services.waf.model.ListIpSetsRequest;
import software.amazon.awssdk.services.waf.model.ListIpSetsResponse;
import software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsResponse;
import software.amazon.awssdk.services.waf.model.ListRateBasedRulesRequest;
import software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse;
import software.amazon.awssdk.services.waf.model.ListRegexMatchSetsRequest;
import software.amazon.awssdk.services.waf.model.ListRegexMatchSetsResponse;
import software.amazon.awssdk.services.waf.model.ListRegexPatternSetsRequest;
import software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse;
import software.amazon.awssdk.services.waf.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.waf.model.ListRulesRequest;
import software.amazon.awssdk.services.waf.model.ListRulesResponse;
import software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsRequest;
import software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsResponse;
import software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsRequest;
import software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse;
import software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsRequest;
import software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsResponse;
import software.amazon.awssdk.services.waf.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.waf.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.waf.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.waf.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.waf.model.ListXssMatchSetsRequest;
import software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse;
import software.amazon.awssdk.services.waf.model.PutLoggingConfigurationRequest;
import software.amazon.awssdk.services.waf.model.PutLoggingConfigurationResponse;
import software.amazon.awssdk.services.waf.model.PutPermissionPolicyRequest;
import software.amazon.awssdk.services.waf.model.PutPermissionPolicyResponse;
import software.amazon.awssdk.services.waf.model.TagResourceRequest;
import software.amazon.awssdk.services.waf.model.TagResourceResponse;
import software.amazon.awssdk.services.waf.model.UntagResourceRequest;
import software.amazon.awssdk.services.waf.model.UntagResourceResponse;
import software.amazon.awssdk.services.waf.model.UpdateByteMatchSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateByteMatchSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleRequest;
import software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleResponse;
import software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.waf.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.waf.model.UpdateRuleRequest;
import software.amazon.awssdk.services.waf.model.UpdateRuleResponse;
import software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse;
import software.amazon.awssdk.services.waf.model.UpdateWebAclRequest;
import software.amazon.awssdk.services.waf.model.UpdateWebAclResponse;
import software.amazon.awssdk.services.waf.model.UpdateXssMatchSetRequest;
import software.amazon.awssdk.services.waf.model.UpdateXssMatchSetResponse;
import software.amazon.awssdk.services.waf.model.WafBadRequestException;
import software.amazon.awssdk.services.waf.model.WafDisallowedNameException;
import software.amazon.awssdk.services.waf.model.WafEntityMigrationException;
import software.amazon.awssdk.services.waf.model.WafException;
import software.amazon.awssdk.services.waf.model.WafInternalErrorException;
import software.amazon.awssdk.services.waf.model.WafInvalidAccountException;
import software.amazon.awssdk.services.waf.model.WafInvalidOperationException;
import software.amazon.awssdk.services.waf.model.WafInvalidParameterException;
import software.amazon.awssdk.services.waf.model.WafInvalidPermissionPolicyException;
import software.amazon.awssdk.services.waf.model.WafInvalidRegexPatternException;
import software.amazon.awssdk.services.waf.model.WafLimitsExceededException;
import software.amazon.awssdk.services.waf.model.WafNonEmptyEntityException;
import software.amazon.awssdk.services.waf.model.WafNonexistentContainerException;
import software.amazon.awssdk.services.waf.model.WafNonexistentItemException;
import software.amazon.awssdk.services.waf.model.WafReferencedItemException;
import software.amazon.awssdk.services.waf.model.WafServiceLinkedRoleErrorException;
import software.amazon.awssdk.services.waf.model.WafStaleDataException;
import software.amazon.awssdk.services.waf.model.WafSubscriptionNotFoundException;
import software.amazon.awssdk.services.waf.model.WafTagOperationException;
import software.amazon.awssdk.services.waf.model.WafTagOperationInternalErrorException;
import software.amazon.awssdk.services.waf.transform.CreateByteMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateGeoMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateRateBasedRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateRegexMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateSizeConstraintSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateSqlInjectionMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateWebAclMigrationStackRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateWebAclRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.CreateXssMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteByteMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteGeoMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeletePermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteRateBasedRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteRegexMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteSizeConstraintSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteSqlInjectionMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteWebAclRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.DeleteXssMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetByteMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetChangeTokenRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetChangeTokenStatusRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetGeoMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetPermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetRateBasedRuleManagedKeysRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetRateBasedRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetRegexMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetSampledRequestsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetSizeConstraintSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetSqlInjectionMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetWebAclRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.GetXssMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListActivatedRulesInRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListByteMatchSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListGeoMatchSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListLoggingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListRateBasedRulesRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListRegexMatchSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListRegexPatternSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListSizeConstraintSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListSqlInjectionMatchSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListSubscribedRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListWebAcLsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.ListXssMatchSetsRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.PutLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.PutPermissionPolicyRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateByteMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateGeoMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateRateBasedRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateRegexMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateRegexPatternSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateRuleRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateSizeConstraintSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateSqlInjectionMatchSetRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateWebAclRequestMarshaller;
import software.amazon.awssdk.services.waf.transform.UpdateXssMatchSetRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWafClient
implements WafClient {
    private static final Logger log = Logger.loggerFor(DefaultWafClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final WafServiceClientConfiguration serviceClientConfiguration;

    protected DefaultWafClient(WafServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateByteMatchSetResponse createByteMatchSet(CreateByteMatchSetRequest createByteMatchSetRequest) throws WafDisallowedNameException, WafInternalErrorException, WafInvalidAccountException, WafInvalidParameterException, WafStaleDataException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateByteMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createByteMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateByteMatchSet");
            CreateByteMatchSetResponse createByteMatchSetResponse = (CreateByteMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateByteMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createByteMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateByteMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createByteMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createByteMatchSet$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGeoMatchSetResponse createGeoMatchSet(CreateGeoMatchSetRequest createGeoMatchSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafDisallowedNameException, WafInvalidParameterException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGeoMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createGeoMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGeoMatchSet");
            CreateGeoMatchSetResponse createGeoMatchSetResponse = (CreateGeoMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGeoMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGeoMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGeoMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGeoMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createGeoMatchSet$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIpSetResponse createIPSet(CreateIpSetRequest createIpSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafDisallowedNameException, WafInvalidParameterException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIpSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIPSet");
            CreateIpSetResponse createIpSetResponse = (CreateIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIPSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIpSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIpSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createIPSet$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRateBasedRuleResponse createRateBasedRule(CreateRateBasedRuleRequest createRateBasedRuleRequest) throws WafStaleDataException, WafInternalErrorException, WafDisallowedNameException, WafInvalidParameterException, WafLimitsExceededException, WafTagOperationException, WafTagOperationInternalErrorException, WafBadRequestException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRateBasedRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createRateBasedRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRateBasedRule");
            CreateRateBasedRuleResponse createRateBasedRuleResponse = (CreateRateBasedRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRateBasedRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRateBasedRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRateBasedRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRateBasedRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createRateBasedRule$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRegexMatchSetResponse createRegexMatchSet(CreateRegexMatchSetRequest createRegexMatchSetRequest) throws WafStaleDataException, WafInternalErrorException, WafDisallowedNameException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRegexMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createRegexMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRegexMatchSet");
            CreateRegexMatchSetResponse createRegexMatchSetResponse = (CreateRegexMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRegexMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRegexMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRegexMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRegexMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createRegexMatchSet$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRegexPatternSetResponse createRegexPatternSet(CreateRegexPatternSetRequest createRegexPatternSetRequest) throws WafStaleDataException, WafInternalErrorException, WafDisallowedNameException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRegexPatternSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRegexPatternSet");
            CreateRegexPatternSetResponse createRegexPatternSetResponse = (CreateRegexPatternSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRegexPatternSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRegexPatternSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRegexPatternSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createRegexPatternSet$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws WafStaleDataException, WafInternalErrorException, WafDisallowedNameException, WafInvalidParameterException, WafLimitsExceededException, WafTagOperationException, WafTagOperationInternalErrorException, WafBadRequestException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRule");
            CreateRuleResponse createRuleResponse = (CreateRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createRule$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) throws WafStaleDataException, WafInternalErrorException, WafDisallowedNameException, WafLimitsExceededException, WafTagOperationException, WafTagOperationInternalErrorException, WafBadRequestException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRuleGroup");
            CreateRuleGroupResponse createRuleGroupResponse = (CreateRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createRuleGroup$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSizeConstraintSetResponse createSizeConstraintSet(CreateSizeConstraintSetRequest createSizeConstraintSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafDisallowedNameException, WafInvalidParameterException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSizeConstraintSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createSizeConstraintSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSizeConstraintSet");
            CreateSizeConstraintSetResponse createSizeConstraintSetResponse = (CreateSizeConstraintSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSizeConstraintSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSizeConstraintSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSizeConstraintSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSizeConstraintSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createSizeConstraintSet$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSqlInjectionMatchSetResponse createSqlInjectionMatchSet(CreateSqlInjectionMatchSetRequest createSqlInjectionMatchSetRequest) throws WafDisallowedNameException, WafInternalErrorException, WafInvalidAccountException, WafInvalidParameterException, WafStaleDataException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSqlInjectionMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createSqlInjectionMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSqlInjectionMatchSet");
            CreateSqlInjectionMatchSetResponse createSqlInjectionMatchSetResponse = (CreateSqlInjectionMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSqlInjectionMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSqlInjectionMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSqlInjectionMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSqlInjectionMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createSqlInjectionMatchSet$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebAclResponse createWebACL(CreateWebAclRequest createWebAclRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafDisallowedNameException, WafInvalidParameterException, WafLimitsExceededException, WafTagOperationException, WafTagOperationInternalErrorException, WafBadRequestException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWebAclResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWebACL");
            CreateWebAclResponse createWebAclResponse = (CreateWebAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWebACL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWebAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWebAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createWebACL$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebAclMigrationStackResponse createWebACLMigrationStack(CreateWebAclMigrationStackRequest createWebAclMigrationStackRequest) throws WafInternalErrorException, WafInvalidParameterException, WafInvalidOperationException, WafNonexistentItemException, WafEntityMigrationException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWebAclMigrationStackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createWebAclMigrationStackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWebACLMigrationStack");
            CreateWebAclMigrationStackResponse createWebAclMigrationStackResponse = (CreateWebAclMigrationStackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWebACLMigrationStack").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWebAclMigrationStackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWebAclMigrationStackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWebAclMigrationStackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createWebACLMigrationStack$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateXssMatchSetResponse createXssMatchSet(CreateXssMatchSetRequest createXssMatchSetRequest) throws WafDisallowedNameException, WafInternalErrorException, WafInvalidAccountException, WafInvalidParameterException, WafStaleDataException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateXssMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, createXssMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateXssMatchSet");
            CreateXssMatchSetResponse createXssMatchSetResponse = (CreateXssMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateXssMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createXssMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateXssMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createXssMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$createXssMatchSet$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteByteMatchSetResponse deleteByteMatchSet(DeleteByteMatchSetRequest deleteByteMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafStaleDataException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteByteMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteByteMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteByteMatchSet");
            DeleteByteMatchSetResponse deleteByteMatchSetResponse = (DeleteByteMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteByteMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteByteMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteByteMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteByteMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteByteMatchSet$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGeoMatchSetResponse deleteGeoMatchSet(DeleteGeoMatchSetRequest deleteGeoMatchSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGeoMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteGeoMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGeoMatchSet");
            DeleteGeoMatchSetResponse deleteGeoMatchSetResponse = (DeleteGeoMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGeoMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGeoMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGeoMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGeoMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteGeoMatchSet$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIpSetResponse deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIpSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIPSet");
            DeleteIpSetResponse deleteIpSetResponse = (DeleteIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIPSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIpSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIpSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteIPSet$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoggingConfigurationResponse deleteLoggingConfiguration(DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) throws WafInternalErrorException, WafNonexistentItemException, WafStaleDataException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoggingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoggingConfiguration");
            DeleteLoggingConfigurationResponse deleteLoggingConfigurationResponse = (DeleteLoggingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoggingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoggingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLoggingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteLoggingConfiguration$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionPolicyResponse deletePermissionPolicy(DeletePermissionPolicyRequest deletePermissionPolicyRequest) throws WafInternalErrorException, WafStaleDataException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deletePermissionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermissionPolicy");
            DeletePermissionPolicyResponse deletePermissionPolicyResponse = (DeletePermissionPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermissionPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePermissionPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePermissionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePermissionPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deletePermissionPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRateBasedRuleResponse deleteRateBasedRule(DeleteRateBasedRuleRequest deleteRateBasedRuleRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRateBasedRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteRateBasedRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRateBasedRule");
            DeleteRateBasedRuleResponse deleteRateBasedRuleResponse = (DeleteRateBasedRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRateBasedRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRateBasedRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRateBasedRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRateBasedRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteRateBasedRule$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRegexMatchSetResponse deleteRegexMatchSet(DeleteRegexMatchSetRequest deleteRegexMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafStaleDataException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRegexMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteRegexMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRegexMatchSet");
            DeleteRegexMatchSetResponse deleteRegexMatchSetResponse = (DeleteRegexMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRegexMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRegexMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRegexMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRegexMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteRegexMatchSet$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRegexPatternSetResponse deleteRegexPatternSet(DeleteRegexPatternSetRequest deleteRegexPatternSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafStaleDataException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRegexPatternSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRegexPatternSet");
            DeleteRegexPatternSetResponse deleteRegexPatternSetResponse = (DeleteRegexPatternSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRegexPatternSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRegexPatternSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRegexPatternSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteRegexPatternSet$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRule");
            DeleteRuleResponse deleteRuleResponse = (DeleteRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteRule$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) throws WafStaleDataException, WafInternalErrorException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, WafInvalidOperationException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRuleGroup");
            DeleteRuleGroupResponse deleteRuleGroupResponse = (DeleteRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteRuleGroup$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSizeConstraintSetResponse deleteSizeConstraintSet(DeleteSizeConstraintSetRequest deleteSizeConstraintSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSizeConstraintSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteSizeConstraintSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSizeConstraintSet");
            DeleteSizeConstraintSetResponse deleteSizeConstraintSetResponse = (DeleteSizeConstraintSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSizeConstraintSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSizeConstraintSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSizeConstraintSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSizeConstraintSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteSizeConstraintSet$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSqlInjectionMatchSetResponse deleteSqlInjectionMatchSet(DeleteSqlInjectionMatchSetRequest deleteSqlInjectionMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafStaleDataException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSqlInjectionMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteSqlInjectionMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSqlInjectionMatchSet");
            DeleteSqlInjectionMatchSetResponse deleteSqlInjectionMatchSetResponse = (DeleteSqlInjectionMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSqlInjectionMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSqlInjectionMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSqlInjectionMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSqlInjectionMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteSqlInjectionMatchSet$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebAclResponse deleteWebACL(DeleteWebAclRequest deleteWebAclRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafNonEmptyEntityException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebAclResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebACL");
            DeleteWebAclResponse deleteWebAclResponse = (DeleteWebAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebACL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWebAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWebAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteWebACL$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteXssMatchSetResponse deleteXssMatchSet(DeleteXssMatchSetRequest deleteXssMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafReferencedItemException, WafStaleDataException, WafNonEmptyEntityException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteXssMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, deleteXssMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteXssMatchSet");
            DeleteXssMatchSetResponse deleteXssMatchSetResponse = (DeleteXssMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteXssMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteXssMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteXssMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteXssMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$deleteXssMatchSet$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetByteMatchSetResponse getByteMatchSet(GetByteMatchSetRequest getByteMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetByteMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getByteMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetByteMatchSet");
            GetByteMatchSetResponse getByteMatchSetResponse = (GetByteMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetByteMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getByteMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetByteMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getByteMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getByteMatchSet$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeTokenResponse getChangeToken(GetChangeTokenRequest getChangeTokenRequest) throws WafInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChangeTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getChangeTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChangeToken");
            GetChangeTokenResponse getChangeTokenResponse = (GetChangeTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChangeToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getChangeTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChangeTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChangeTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getChangeToken$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeTokenStatusResponse getChangeTokenStatus(GetChangeTokenStatusRequest getChangeTokenStatusRequest) throws WafNonexistentItemException, WafInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChangeTokenStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getChangeTokenStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChangeTokenStatus");
            GetChangeTokenStatusResponse getChangeTokenStatusResponse = (GetChangeTokenStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChangeTokenStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getChangeTokenStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChangeTokenStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChangeTokenStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getChangeTokenStatus$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGeoMatchSetResponse getGeoMatchSet(GetGeoMatchSetRequest getGeoMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGeoMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getGeoMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGeoMatchSet");
            GetGeoMatchSetResponse getGeoMatchSetResponse = (GetGeoMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeoMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGeoMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGeoMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGeoMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getGeoMatchSet$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIpSetResponse getIPSet(GetIpSetRequest getIpSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIpSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIPSet");
            GetIpSetResponse getIpSetResponse = (GetIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIPSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIpSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIpSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getIPSet$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLoggingConfigurationResponse getLoggingConfiguration(GetLoggingConfigurationRequest getLoggingConfigurationRequest) throws WafInternalErrorException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoggingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoggingConfiguration");
            GetLoggingConfigurationResponse getLoggingConfigurationResponse = (GetLoggingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoggingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLoggingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLoggingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getLoggingConfiguration$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPermissionPolicyResponse getPermissionPolicy(GetPermissionPolicyRequest getPermissionPolicyRequest) throws WafInternalErrorException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPermissionPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getPermissionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPermissionPolicy");
            GetPermissionPolicyResponse getPermissionPolicyResponse = (GetPermissionPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPermissionPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPermissionPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPermissionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPermissionPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getPermissionPolicy$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRateBasedRuleResponse getRateBasedRule(GetRateBasedRuleRequest getRateBasedRuleRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRateBasedRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getRateBasedRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRateBasedRule");
            GetRateBasedRuleResponse getRateBasedRuleResponse = (GetRateBasedRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRateBasedRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRateBasedRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRateBasedRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRateBasedRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getRateBasedRule$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRateBasedRuleManagedKeysResponse getRateBasedRuleManagedKeys(GetRateBasedRuleManagedKeysRequest getRateBasedRuleManagedKeysRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, WafInvalidParameterException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRateBasedRuleManagedKeysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getRateBasedRuleManagedKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRateBasedRuleManagedKeys");
            GetRateBasedRuleManagedKeysResponse getRateBasedRuleManagedKeysResponse = (GetRateBasedRuleManagedKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRateBasedRuleManagedKeys").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRateBasedRuleManagedKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRateBasedRuleManagedKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRateBasedRuleManagedKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getRateBasedRuleManagedKeys$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRegexMatchSetResponse getRegexMatchSet(GetRegexMatchSetRequest getRegexMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegexMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getRegexMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegexMatchSet");
            GetRegexMatchSetResponse getRegexMatchSetResponse = (GetRegexMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegexMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRegexMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRegexMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRegexMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getRegexMatchSet$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRegexPatternSetResponse getRegexPatternSet(GetRegexPatternSetRequest getRegexPatternSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegexPatternSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegexPatternSet");
            GetRegexPatternSetResponse getRegexPatternSetResponse = (GetRegexPatternSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegexPatternSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRegexPatternSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRegexPatternSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getRegexPatternSet$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRuleResponse getRule(GetRuleRequest getRuleRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRule");
            GetRuleResponse getRuleResponse = (GetRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getRule$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRuleGroupResponse getRuleGroup(GetRuleGroupRequest getRuleGroupRequest) throws WafInternalErrorException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRuleGroup");
            GetRuleGroupResponse getRuleGroupResponse = (GetRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getRuleGroup$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSampledRequestsResponse getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest) throws WafNonexistentItemException, WafInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSampledRequestsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getSampledRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSampledRequests");
            GetSampledRequestsResponse getSampledRequestsResponse = (GetSampledRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSampledRequests").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSampledRequestsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSampledRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSampledRequestsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getSampledRequests$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSizeConstraintSetResponse getSizeConstraintSet(GetSizeConstraintSetRequest getSizeConstraintSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSizeConstraintSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getSizeConstraintSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSizeConstraintSet");
            GetSizeConstraintSetResponse getSizeConstraintSetResponse = (GetSizeConstraintSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSizeConstraintSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSizeConstraintSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSizeConstraintSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSizeConstraintSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getSizeConstraintSet$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSqlInjectionMatchSetResponse getSqlInjectionMatchSet(GetSqlInjectionMatchSetRequest getSqlInjectionMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSqlInjectionMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getSqlInjectionMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSqlInjectionMatchSet");
            GetSqlInjectionMatchSetResponse getSqlInjectionMatchSetResponse = (GetSqlInjectionMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSqlInjectionMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSqlInjectionMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSqlInjectionMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSqlInjectionMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getSqlInjectionMatchSet$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWebAclResponse getWebACL(GetWebAclRequest getWebAclRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWebAclResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWebACL");
            GetWebAclResponse getWebAclResponse = (GetWebAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWebACL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWebAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWebAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getWebACL$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetXssMatchSetResponse getXssMatchSet(GetXssMatchSetRequest getXssMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafNonexistentItemException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetXssMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, getXssMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetXssMatchSet");
            GetXssMatchSetResponse getXssMatchSetResponse = (GetXssMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetXssMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getXssMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetXssMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getXssMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$getXssMatchSet$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActivatedRulesInRuleGroupResponse listActivatedRulesInRuleGroup(ListActivatedRulesInRuleGroupRequest listActivatedRulesInRuleGroupRequest) throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActivatedRulesInRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listActivatedRulesInRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActivatedRulesInRuleGroup");
            ListActivatedRulesInRuleGroupResponse listActivatedRulesInRuleGroupResponse = (ListActivatedRulesInRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActivatedRulesInRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listActivatedRulesInRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListActivatedRulesInRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listActivatedRulesInRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listActivatedRulesInRuleGroup$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListByteMatchSetsResponse listByteMatchSets(ListByteMatchSetsRequest listByteMatchSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListByteMatchSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listByteMatchSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListByteMatchSets");
            ListByteMatchSetsResponse listByteMatchSetsResponse = (ListByteMatchSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListByteMatchSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listByteMatchSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListByteMatchSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listByteMatchSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listByteMatchSets$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGeoMatchSetsResponse listGeoMatchSets(ListGeoMatchSetsRequest listGeoMatchSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGeoMatchSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listGeoMatchSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGeoMatchSets");
            ListGeoMatchSetsResponse listGeoMatchSetsResponse = (ListGeoMatchSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeoMatchSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGeoMatchSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGeoMatchSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGeoMatchSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listGeoMatchSets$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIpSetsResponse listIPSets(ListIpSetsRequest listIpSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIpSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listIpSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIPSets");
            ListIpSetsResponse listIpSetsResponse = (ListIpSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIPSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIpSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIpSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIpSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listIPSets$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLoggingConfigurationsResponse listLoggingConfigurations(ListLoggingConfigurationsRequest listLoggingConfigurationsRequest) throws WafInternalErrorException, WafNonexistentItemException, WafInvalidParameterException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLoggingConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listLoggingConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLoggingConfigurations");
            ListLoggingConfigurationsResponse listLoggingConfigurationsResponse = (ListLoggingConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLoggingConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLoggingConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLoggingConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLoggingConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listLoggingConfigurations$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRateBasedRulesResponse listRateBasedRules(ListRateBasedRulesRequest listRateBasedRulesRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRateBasedRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listRateBasedRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRateBasedRules");
            ListRateBasedRulesResponse listRateBasedRulesResponse = (ListRateBasedRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRateBasedRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRateBasedRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRateBasedRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRateBasedRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listRateBasedRules$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRegexMatchSetsResponse listRegexMatchSets(ListRegexMatchSetsRequest listRegexMatchSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRegexMatchSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listRegexMatchSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegexMatchSets");
            ListRegexMatchSetsResponse listRegexMatchSetsResponse = (ListRegexMatchSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegexMatchSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRegexMatchSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRegexMatchSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRegexMatchSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listRegexMatchSets$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRegexPatternSetsResponse listRegexPatternSets(ListRegexPatternSetsRequest listRegexPatternSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRegexPatternSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listRegexPatternSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegexPatternSets");
            ListRegexPatternSetsResponse listRegexPatternSetsResponse = (ListRegexPatternSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegexPatternSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRegexPatternSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRegexPatternSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRegexPatternSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listRegexPatternSets$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws WafInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleGroups");
            ListRuleGroupsResponse listRuleGroupsResponse = (ListRuleGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRuleGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRuleGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listRuleGroups$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRules");
            ListRulesResponse listRulesResponse = (ListRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listRules$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSizeConstraintSetsResponse listSizeConstraintSets(ListSizeConstraintSetsRequest listSizeConstraintSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSizeConstraintSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listSizeConstraintSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSizeConstraintSets");
            ListSizeConstraintSetsResponse listSizeConstraintSetsResponse = (ListSizeConstraintSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSizeConstraintSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSizeConstraintSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSizeConstraintSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSizeConstraintSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listSizeConstraintSets$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSqlInjectionMatchSetsResponse listSqlInjectionMatchSets(ListSqlInjectionMatchSetsRequest listSqlInjectionMatchSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSqlInjectionMatchSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listSqlInjectionMatchSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSqlInjectionMatchSets");
            ListSqlInjectionMatchSetsResponse listSqlInjectionMatchSetsResponse = (ListSqlInjectionMatchSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSqlInjectionMatchSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSqlInjectionMatchSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSqlInjectionMatchSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSqlInjectionMatchSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listSqlInjectionMatchSets$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscribedRuleGroupsResponse listSubscribedRuleGroups(ListSubscribedRuleGroupsRequest listSubscribedRuleGroupsRequest) throws WafNonexistentItemException, WafInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSubscribedRuleGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listSubscribedRuleGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSubscribedRuleGroups");
            ListSubscribedRuleGroupsResponse listSubscribedRuleGroupsResponse = (ListSubscribedRuleGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscribedRuleGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscribedRuleGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSubscribedRuleGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSubscribedRuleGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listSubscribedRuleGroups$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, WafBadRequestException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listTagsForResource$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebAcLsResponse listWebACLs(ListWebAcLsRequest listWebAcLsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebAcLsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listWebAcLsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebACLs");
            ListWebAcLsResponse listWebAcLsResponse = (ListWebAcLsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebACLs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWebAcLsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWebAcLsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWebAcLsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listWebACLs$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListXssMatchSetsResponse listXssMatchSets(ListXssMatchSetsRequest listXssMatchSetsRequest) throws WafInternalErrorException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListXssMatchSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, listXssMatchSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListXssMatchSets");
            ListXssMatchSetsResponse listXssMatchSetsResponse = (ListXssMatchSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListXssMatchSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listXssMatchSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListXssMatchSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listXssMatchSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$listXssMatchSets$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLoggingConfigurationResponse putLoggingConfiguration(PutLoggingConfigurationRequest putLoggingConfigurationRequest) throws WafInternalErrorException, WafNonexistentItemException, WafStaleDataException, WafServiceLinkedRoleErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLoggingConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, putLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLoggingConfiguration");
            PutLoggingConfigurationResponse putLoggingConfigurationResponse = (PutLoggingConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLoggingConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLoggingConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLoggingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putLoggingConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$putLoggingConfiguration$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPermissionPolicyResponse putPermissionPolicy(PutPermissionPolicyRequest putPermissionPolicyRequest) throws WafInternalErrorException, WafStaleDataException, WafNonexistentItemException, WafInvalidPermissionPolicyException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, putPermissionPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPermissionPolicy");
            PutPermissionPolicyResponse putPermissionPolicyResponse = (PutPermissionPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermissionPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPermissionPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPermissionPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPermissionPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$putPermissionPolicy$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws WafInternalErrorException, WafInvalidParameterException, WafLimitsExceededException, WafNonexistentItemException, WafBadRequestException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$tagResource$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws WafInternalErrorException, WafInvalidParameterException, WafNonexistentItemException, WafBadRequestException, WafTagOperationException, WafTagOperationInternalErrorException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$untagResource$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateByteMatchSetResponse updateByteMatchSet(UpdateByteMatchSetRequest updateByteMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafStaleDataException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateByteMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateByteMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateByteMatchSet");
            UpdateByteMatchSetResponse updateByteMatchSetResponse = (UpdateByteMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateByteMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateByteMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateByteMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateByteMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateByteMatchSet$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGeoMatchSetResponse updateGeoMatchSet(UpdateGeoMatchSetRequest updateGeoMatchSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafReferencedItemException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGeoMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateGeoMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGeoMatchSet");
            UpdateGeoMatchSetResponse updateGeoMatchSetResponse = (UpdateGeoMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGeoMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGeoMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGeoMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGeoMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateGeoMatchSet$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIpSetResponse updateIPSet(UpdateIpSetRequest updateIpSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafReferencedItemException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIpSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateIpSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIPSet");
            UpdateIpSetResponse updateIpSetResponse = (UpdateIpSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIPSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIpSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIpSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIpSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateIPSet$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRateBasedRuleResponse updateRateBasedRule(UpdateRateBasedRuleRequest updateRateBasedRuleRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafReferencedItemException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRateBasedRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateRateBasedRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRateBasedRule");
            UpdateRateBasedRuleResponse updateRateBasedRuleResponse = (UpdateRateBasedRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRateBasedRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRateBasedRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRateBasedRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRateBasedRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateRateBasedRule$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRegexMatchSetResponse updateRegexMatchSet(UpdateRegexMatchSetRequest updateRegexMatchSetRequest) throws WafStaleDataException, WafInternalErrorException, WafDisallowedNameException, WafLimitsExceededException, WafNonexistentItemException, WafNonexistentContainerException, WafInvalidOperationException, WafInvalidAccountException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRegexMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateRegexMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRegexMatchSet");
            UpdateRegexMatchSetResponse updateRegexMatchSetResponse = (UpdateRegexMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRegexMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRegexMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRegexMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRegexMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateRegexMatchSet$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRegexPatternSetResponse updateRegexPatternSet(UpdateRegexPatternSetRequest updateRegexPatternSetRequest) throws WafStaleDataException, WafInternalErrorException, WafLimitsExceededException, WafNonexistentItemException, WafNonexistentContainerException, WafInvalidOperationException, WafInvalidAccountException, WafInvalidRegexPatternException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRegexPatternSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateRegexPatternSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRegexPatternSet");
            UpdateRegexPatternSetResponse updateRegexPatternSetResponse = (UpdateRegexPatternSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRegexPatternSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRegexPatternSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRegexPatternSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRegexPatternSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateRegexPatternSet$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRuleResponse updateRule(UpdateRuleRequest updateRuleRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafReferencedItemException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRule");
            UpdateRuleResponse updateRuleResponse = (UpdateRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateRule$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) throws WafStaleDataException, WafInternalErrorException, WafNonexistentContainerException, WafNonexistentItemException, WafInvalidOperationException, WafLimitsExceededException, WafInvalidParameterException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRuleGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateRuleGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRuleGroup");
            UpdateRuleGroupResponse updateRuleGroupResponse = (UpdateRuleGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRuleGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRuleGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRuleGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRuleGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateRuleGroup$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSizeConstraintSetResponse updateSizeConstraintSet(UpdateSizeConstraintSetRequest updateSizeConstraintSetRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafReferencedItemException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSizeConstraintSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateSizeConstraintSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSizeConstraintSet");
            UpdateSizeConstraintSetResponse updateSizeConstraintSetResponse = (UpdateSizeConstraintSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSizeConstraintSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSizeConstraintSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSizeConstraintSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSizeConstraintSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateSizeConstraintSet$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSqlInjectionMatchSetResponse updateSqlInjectionMatchSet(UpdateSqlInjectionMatchSetRequest updateSqlInjectionMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafStaleDataException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSqlInjectionMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateSqlInjectionMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSqlInjectionMatchSet");
            UpdateSqlInjectionMatchSetResponse updateSqlInjectionMatchSetResponse = (UpdateSqlInjectionMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSqlInjectionMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSqlInjectionMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSqlInjectionMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSqlInjectionMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateSqlInjectionMatchSet$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWebAclResponse updateWebACL(UpdateWebAclRequest updateWebAclRequest) throws WafStaleDataException, WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafReferencedItemException, WafLimitsExceededException, WafSubscriptionNotFoundException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWebAclResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateWebAclRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWebACL");
            UpdateWebAclResponse updateWebAclResponse = (UpdateWebAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWebACL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWebAclRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWebAclRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWebAclResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateWebACL$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateXssMatchSetResponse updateXssMatchSet(UpdateXssMatchSetRequest updateXssMatchSetRequest) throws WafInternalErrorException, WafInvalidAccountException, WafInvalidOperationException, WafInvalidParameterException, WafNonexistentContainerException, WafNonexistentItemException, WafStaleDataException, WafLimitsExceededException, AwsServiceException, SdkClientException, WafException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateXssMatchSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWafClient.resolveMetricPublishers(this.clientConfiguration, updateXssMatchSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WAF");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateXssMatchSet");
            UpdateXssMatchSetResponse updateXssMatchSetResponse = (UpdateXssMatchSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateXssMatchSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateXssMatchSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateXssMatchSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateXssMatchSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWafClient.lambda$updateXssMatchSet$76((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "waf";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WafException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("WAFServiceLinkedRoleErrorException").exceptionBuilderSupplier(WafServiceLinkedRoleErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFSubscriptionNotFoundException").exceptionBuilderSupplier(WafSubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFLimitsExceededException").exceptionBuilderSupplier(WafLimitsExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFEntityMigrationException").exceptionBuilderSupplier(WafEntityMigrationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFInvalidParameterException").exceptionBuilderSupplier(WafInvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFStaleDataException").exceptionBuilderSupplier(WafStaleDataException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFInvalidRegexPatternException").exceptionBuilderSupplier(WafInvalidRegexPatternException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFNonexistentItemException").exceptionBuilderSupplier(WafNonexistentItemException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFNonEmptyEntityException").exceptionBuilderSupplier(WafNonEmptyEntityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFBadRequestException").exceptionBuilderSupplier(WafBadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFDisallowedNameException").exceptionBuilderSupplier(WafDisallowedNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFInvalidPermissionPolicyException").exceptionBuilderSupplier(WafInvalidPermissionPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFNonexistentContainerException").exceptionBuilderSupplier(WafNonexistentContainerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFInvalidAccountException").exceptionBuilderSupplier(WafInvalidAccountException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFReferencedItemException").exceptionBuilderSupplier(WafReferencedItemException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFTagOperationException").exceptionBuilderSupplier(WafTagOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFTagOperationInternalErrorException").exceptionBuilderSupplier(WafTagOperationInternalErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFInvalidOperationException").exceptionBuilderSupplier(WafInvalidOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WAFInternalErrorException").exceptionBuilderSupplier(WafInternalErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final WafServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateXssMatchSet$76(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWebACL$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSqlInjectionMatchSet$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSizeConstraintSet$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRuleGroup$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRule$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRegexPatternSet$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRegexMatchSet$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRateBasedRule$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIPSet$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGeoMatchSet$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateByteMatchSet$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPermissionPolicy$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLoggingConfiguration$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listXssMatchSets$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWebACLs$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSubscribedRuleGroups$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSqlInjectionMatchSets$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSizeConstraintSets$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRules$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleGroups$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegexPatternSets$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegexMatchSets$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRateBasedRules$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLoggingConfigurations$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIPSets$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGeoMatchSets$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listByteMatchSets$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActivatedRulesInRuleGroup$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getXssMatchSet$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWebACL$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSqlInjectionMatchSet$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSizeConstraintSet$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSampledRequests$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRuleGroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRule$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegexPatternSet$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegexMatchSet$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRateBasedRuleManagedKeys$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRateBasedRule$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPermissionPolicy$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoggingConfiguration$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIPSet$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGeoMatchSet$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChangeTokenStatus$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChangeToken$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getByteMatchSet$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteXssMatchSet$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebACL$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSqlInjectionMatchSet$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSizeConstraintSet$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRuleGroup$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRule$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRegexPatternSet$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRegexMatchSet$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRateBasedRule$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermissionPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoggingConfiguration$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIPSet$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGeoMatchSet$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteByteMatchSet$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createXssMatchSet$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWebACLMigrationStack$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWebACL$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSqlInjectionMatchSet$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSizeConstraintSet$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRuleGroup$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRule$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRegexPatternSet$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRegexMatchSet$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRateBasedRule$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIPSet$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGeoMatchSet$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createByteMatchSet$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

