/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSizeConstraintSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListSizeConstraintSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListSizeConstraintSetsResponse.getter(ListSizeConstraintSetsResponse::nextMarker)).setter(ListSizeConstraintSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<SizeConstraintSetSummary>> SIZE_CONSTRAINT_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SizeConstraintSets").getter(ListSizeConstraintSetsResponse.getter(ListSizeConstraintSetsResponse::sizeConstraintSets)).setter(ListSizeConstraintSetsResponse.setter(Builder::sizeConstraintSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SizeConstraintSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, SIZE_CONSTRAINT_SETS_FIELD));
    private final String nextMarker;
    private final List<SizeConstraintSetSummary> sizeConstraintSets;

    private ListSizeConstraintSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.sizeConstraintSets = builder.sizeConstraintSets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasSizeConstraintSets() {
        return this.sizeConstraintSets != null && !(this.sizeConstraintSets instanceof SdkAutoConstructList);
    }

    public final List<SizeConstraintSetSummary> sizeConstraintSets() {
        return this.sizeConstraintSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSizeConstraintSets() ? this.sizeConstraintSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSizeConstraintSetsResponse)) {
            return false;
        }
        ListSizeConstraintSetsResponse other = (ListSizeConstraintSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasSizeConstraintSets() == other.hasSizeConstraintSets() && Objects.equals(this.sizeConstraintSets(), other.sizeConstraintSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListSizeConstraintSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("SizeConstraintSets", this.hasSizeConstraintSets() ? this.sizeConstraintSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "SizeConstraintSets": {
                return Optional.ofNullable(clazz.cast(this.sizeConstraintSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSizeConstraintSetsResponse, T> g) {
        return obj -> g.apply((ListSizeConstraintSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SizeConstraintSetSummary> sizeConstraintSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSizeConstraintSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.sizeConstraintSets(model.sizeConstraintSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<SizeConstraintSetSummary.Builder> getSizeConstraintSets() {
            List<SizeConstraintSetSummary.Builder> result = SizeConstraintSetSummariesCopier.copyToBuilder(this.sizeConstraintSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSizeConstraintSets(Collection<SizeConstraintSetSummary.BuilderImpl> sizeConstraintSets) {
            this.sizeConstraintSets = SizeConstraintSetSummariesCopier.copyFromBuilder(sizeConstraintSets);
        }

        @Override
        @Transient
        public final Builder sizeConstraintSets(Collection<SizeConstraintSetSummary> sizeConstraintSets) {
            this.sizeConstraintSets = SizeConstraintSetSummariesCopier.copy(sizeConstraintSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sizeConstraintSets(SizeConstraintSetSummary ... sizeConstraintSets) {
            this.sizeConstraintSets(Arrays.asList(sizeConstraintSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sizeConstraintSets(Consumer<SizeConstraintSetSummary.Builder> ... sizeConstraintSets) {
            this.sizeConstraintSets(Stream.of(sizeConstraintSets).map(c -> (SizeConstraintSetSummary)((SizeConstraintSetSummary.Builder)SizeConstraintSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSizeConstraintSetsResponse build() {
            return new ListSizeConstraintSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSizeConstraintSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder sizeConstraintSets(Collection<SizeConstraintSetSummary> var1);

        public Builder sizeConstraintSets(SizeConstraintSetSummary ... var1);

        public Builder sizeConstraintSets(Consumer<SizeConstraintSetSummary.Builder> ... var1);
    }
}

