/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraint;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraintsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoMatchSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoMatchSet> {
    private static final SdkField<String> GEO_MATCH_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeoMatchSetId").getter(GeoMatchSet.getter(GeoMatchSet::geoMatchSetId)).setter(GeoMatchSet.setter(Builder::geoMatchSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GeoMatchSet.getter(GeoMatchSet::name)).setter(GeoMatchSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<GeoMatchConstraint>> GEO_MATCH_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GeoMatchConstraints").getter(GeoMatchSet.getter(GeoMatchSet::geoMatchConstraints)).setter(GeoMatchSet.setter(Builder::geoMatchConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeoMatchConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_MATCH_SET_ID_FIELD, NAME_FIELD, GEO_MATCH_CONSTRAINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String geoMatchSetId;
    private final String name;
    private final List<GeoMatchConstraint> geoMatchConstraints;

    private GeoMatchSet(BuilderImpl builder) {
        this.geoMatchSetId = builder.geoMatchSetId;
        this.name = builder.name;
        this.geoMatchConstraints = builder.geoMatchConstraints;
    }

    public final String geoMatchSetId() {
        return this.geoMatchSetId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasGeoMatchConstraints() {
        return this.geoMatchConstraints != null && !(this.geoMatchConstraints instanceof SdkAutoConstructList);
    }

    public final List<GeoMatchConstraint> geoMatchConstraints() {
        return this.geoMatchConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeoMatchConstraints() ? this.geoMatchConstraints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchSet)) {
            return false;
        }
        GeoMatchSet other = (GeoMatchSet)obj;
        return Objects.equals(this.geoMatchSetId(), other.geoMatchSetId()) && Objects.equals(this.name(), other.name()) && this.hasGeoMatchConstraints() == other.hasGeoMatchConstraints() && Objects.equals(this.geoMatchConstraints(), other.geoMatchConstraints());
    }

    public final String toString() {
        return ToString.builder((String)"GeoMatchSet").add("GeoMatchSetId", (Object)this.geoMatchSetId()).add("Name", (Object)this.name()).add("GeoMatchConstraints", this.hasGeoMatchConstraints() ? this.geoMatchConstraints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeoMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.geoMatchSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "GeoMatchConstraints": {
                return Optional.ofNullable(clazz.cast(this.geoMatchConstraints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchSet, T> g) {
        return obj -> g.apply((GeoMatchSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String geoMatchSetId;
        private String name;
        private List<GeoMatchConstraint> geoMatchConstraints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchSet model) {
            this.geoMatchSetId(model.geoMatchSetId);
            this.name(model.name);
            this.geoMatchConstraints(model.geoMatchConstraints);
        }

        public final String getGeoMatchSetId() {
            return this.geoMatchSetId;
        }

        public final void setGeoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
        }

        @Override
        @Transient
        public final Builder geoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GeoMatchConstraint.Builder> getGeoMatchConstraints() {
            List<GeoMatchConstraint.Builder> result = GeoMatchConstraintsCopier.copyToBuilder(this.geoMatchConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeoMatchConstraints(Collection<GeoMatchConstraint.BuilderImpl> geoMatchConstraints) {
            this.geoMatchConstraints = GeoMatchConstraintsCopier.copyFromBuilder(geoMatchConstraints);
        }

        @Override
        @Transient
        public final Builder geoMatchConstraints(Collection<GeoMatchConstraint> geoMatchConstraints) {
            this.geoMatchConstraints = GeoMatchConstraintsCopier.copy(geoMatchConstraints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder geoMatchConstraints(GeoMatchConstraint ... geoMatchConstraints) {
            this.geoMatchConstraints(Arrays.asList(geoMatchConstraints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder geoMatchConstraints(Consumer<GeoMatchConstraint.Builder> ... geoMatchConstraints) {
            this.geoMatchConstraints(Stream.of(geoMatchConstraints).map(c -> (GeoMatchConstraint)((GeoMatchConstraint.Builder)GeoMatchConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GeoMatchSet build() {
            return new GeoMatchSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoMatchSet> {
        public Builder geoMatchSetId(String var1);

        public Builder name(String var1);

        public Builder geoMatchConstraints(Collection<GeoMatchConstraint> var1);

        public Builder geoMatchConstraints(GeoMatchConstraint ... var1);

        public Builder geoMatchConstraints(Consumer<GeoMatchConstraint.Builder> ... var1);
    }
}

