/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.services.waf.model.WebACLUpdate;
import software.amazon.awssdk.services.waf.model.WebACLUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebAclRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateWebAclRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLId").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::webACLId)).setter(UpdateWebAclRequest.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::changeToken)).setter(UpdateWebAclRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<WebACLUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::updates)).setter(UpdateWebAclRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebACLUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WafAction> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultAction").getter(UpdateWebAclRequest.getter(UpdateWebAclRequest::defaultAction)).setter(UpdateWebAclRequest.setter(Builder::defaultAction)).constructor(WafAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD, CHANGE_TOKEN_FIELD, UPDATES_FIELD, DEFAULT_ACTION_FIELD));
    private final String webACLId;
    private final String changeToken;
    private final List<WebACLUpdate> updates;
    private final WafAction defaultAction;

    private UpdateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.defaultAction = builder.defaultAction;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public List<WebACLUpdate> updates() {
        return this.updates;
    }

    public WafAction defaultAction() {
        return this.defaultAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAclRequest)) {
            return false;
        }
        UpdateWebAclRequest other = (UpdateWebAclRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.defaultAction(), other.defaultAction());
    }

    public String toString() {
        return ToString.builder((String)"UpdateWebAclRequest").add("WebACLId", (Object)this.webACLId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.hasUpdates() ? this.updates() : null).add("DefaultAction", (Object)this.defaultAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAclRequest, T> g) {
        return obj -> g.apply((UpdateWebAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String changeToken;
        private List<WebACLUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private WafAction defaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAclRequest model) {
            super(model);
            this.webACLId(model.webACLId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
            this.defaultAction(model.defaultAction);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<WebACLUpdate.Builder> getUpdates() {
            if (this.updates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.updates != null ? (Collection)this.updates.stream().map(WebACLUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<WebACLUpdate> updates) {
            this.updates = WebACLUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(WebACLUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<WebACLUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (WebACLUpdate)((WebACLUpdate.Builder)WebACLUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<WebACLUpdate.BuilderImpl> updates) {
            this.updates = WebACLUpdatesCopier.copyFromBuilder(updates);
        }

        public final WafAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAclRequest build() {
            return new UpdateWebAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWebAclRequest> {
        public Builder webACLId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<WebACLUpdate> var1);

        public Builder updates(WebACLUpdate ... var1);

        public Builder updates(Consumer<WebACLUpdate.Builder> ... var1);

        public Builder defaultAction(WafAction var1);

        default public Builder defaultAction(Consumer<WafAction.Builder> defaultAction) {
            return this.defaultAction((WafAction)((WafAction.Builder)WafAction.builder().applyMutation(defaultAction)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

