/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.TimeWindow;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSampledRequestsRequest
extends WafRequest
implements ToCopyableBuilder<Builder, GetSampledRequestsRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAclId").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::webAclId)).setter(GetSampledRequestsRequest.setter(Builder::webAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::ruleId)).setter(GetSampledRequestsRequest.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeWindow").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::timeWindow)).setter(GetSampledRequestsRequest.setter(Builder::timeWindow)).constructor(TimeWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()}).build();
    private static final SdkField<Long> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxItems").getter(GetSampledRequestsRequest.getter(GetSampledRequestsRequest::maxItems)).setter(GetSampledRequestsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD, RULE_ID_FIELD, TIME_WINDOW_FIELD, MAX_ITEMS_FIELD));
    private final String webAclId;
    private final String ruleId;
    private final TimeWindow timeWindow;
    private final Long maxItems;

    private GetSampledRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.webAclId = builder.webAclId;
        this.ruleId = builder.ruleId;
        this.timeWindow = builder.timeWindow;
        this.maxItems = builder.maxItems;
    }

    public String webAclId() {
        return this.webAclId;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public Long maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsRequest)) {
            return false;
        }
        GetSampledRequestsRequest other = (GetSampledRequestsRequest)((Object)obj);
        return Objects.equals(this.webAclId(), other.webAclId()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.timeWindow(), other.timeWindow()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"GetSampledRequestsRequest").add("WebAclId", (Object)this.webAclId()).add("RuleId", (Object)this.ruleId()).add("TimeWindow", (Object)this.timeWindow()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebAclId": {
                return Optional.ofNullable(clazz.cast(this.webAclId()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "TimeWindow": {
                return Optional.ofNullable(clazz.cast(this.timeWindow()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSampledRequestsRequest, T> g) {
        return obj -> g.apply((GetSampledRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String webAclId;
        private String ruleId;
        private TimeWindow timeWindow;
        private Long maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsRequest model) {
            super(model);
            this.webAclId(model.webAclId);
            this.ruleId(model.ruleId);
            this.timeWindow(model.timeWindow);
            this.maxItems(model.maxItems);
        }

        public final String getWebAclId() {
            return this.webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return this.timeWindow != null ? this.timeWindow.toBuilder() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        public final Long getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Long maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Long maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSampledRequestsRequest build() {
            return new GetSampledRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSampledRequestsRequest> {
        public Builder webAclId(String var1);

        public Builder ruleId(String var1);

        public Builder timeWindow(TimeWindow var1);

        default public Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return this.timeWindow((TimeWindow)((TimeWindow.Builder)TimeWindow.builder().applyMutation(timeWindow)).build());
        }

        public Builder maxItems(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

