/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPSetSummary> {
    private static final SdkField<String> IP_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IPSetSummary.getter(IPSetSummary::ipSetId)).setter(IPSetSummary.setter(Builder::ipSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IPSetSummary.getter(IPSetSummary::name)).setter(IPSetSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_ID_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipSetId;
    private final String name;

    private IPSetSummary(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetSummary)) {
            return false;
        }
        IPSetSummary other = (IPSetSummary)obj;
        return Objects.equals(this.ipSetId(), other.ipSetId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"IPSetSummary").add("IPSetId", (Object)this.ipSetId()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSetId": {
                return Optional.ofNullable(clazz.cast(this.ipSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPSetSummary, T> g) {
        return obj -> g.apply((IPSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetSummary model) {
            this.ipSetId(model.ipSetId);
            this.name(model.name);
        }

        public final String getIpSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public IPSetSummary build() {
            return new IPSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPSetSummary> {
        public Builder ipSetId(String var1);

        public Builder name(String var1);
    }
}

