/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.LogDestinationConfigsCopier;
import software.amazon.awssdk.services.waf.model.RedactedFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfiguration> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LoggingConfiguration.getter(LoggingConfiguration::resourceArn)).setter(LoggingConfiguration.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<String>> LOG_DESTINATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LoggingConfiguration.getter(LoggingConfiguration::logDestinationConfigs)).setter(LoggingConfiguration.setter(Builder::logDestinationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FieldToMatch>> REDACTED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LoggingConfiguration.getter(LoggingConfiguration::redactedFields)).setter(LoggingConfiguration.setter(Builder::redactedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, LOG_DESTINATION_CONFIGS_FIELD, REDACTED_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final List<String> logDestinationConfigs;
    private final List<FieldToMatch> redactedFields;

    private LoggingConfiguration(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.logDestinationConfigs = builder.logDestinationConfigs;
        this.redactedFields = builder.redactedFields;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public boolean hasLogDestinationConfigs() {
        return this.logDestinationConfigs != null && !(this.logDestinationConfigs instanceof SdkAutoConstructList);
    }

    public List<String> logDestinationConfigs() {
        return this.logDestinationConfigs;
    }

    public boolean hasRedactedFields() {
        return this.redactedFields != null && !(this.redactedFields instanceof SdkAutoConstructList);
    }

    public List<FieldToMatch> redactedFields() {
        return this.redactedFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactedFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.logDestinationConfigs(), other.logDestinationConfigs()) && Objects.equals(this.redactedFields(), other.redactedFields());
    }

    public String toString() {
        return ToString.builder((String)"LoggingConfiguration").add("ResourceArn", (Object)this.resourceArn()).add("LogDestinationConfigs", this.logDestinationConfigs()).add("RedactedFields", this.redactedFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "LogDestinationConfigs": {
                return Optional.ofNullable(clazz.cast(this.logDestinationConfigs()));
            }
            case "RedactedFields": {
                return Optional.ofNullable(clazz.cast(this.redactedFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<String> logDestinationConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<FieldToMatch> redactedFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            this.resourceArn(model.resourceArn);
            this.logDestinationConfigs(model.logDestinationConfigs);
            this.redactedFields(model.redactedFields);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getLogDestinationConfigs() {
            return this.logDestinationConfigs;
        }

        @Override
        public final Builder logDestinationConfigs(Collection<String> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDestinationConfigs(String ... logDestinationConfigs) {
            this.logDestinationConfigs(Arrays.asList(logDestinationConfigs));
            return this;
        }

        public final void setLogDestinationConfigs(Collection<String> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
        }

        public final Collection<FieldToMatch.Builder> getRedactedFields() {
            return this.redactedFields != null ? (Collection)this.redactedFields.stream().map(FieldToMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder redactedFields(Collection<FieldToMatch> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copy(redactedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(FieldToMatch ... redactedFields) {
            this.redactedFields(Arrays.asList(redactedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(Consumer<FieldToMatch.Builder> ... redactedFields) {
            this.redactedFields(Stream.of(redactedFields).map(c -> (FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRedactedFields(Collection<FieldToMatch.BuilderImpl> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copyFromBuilder(redactedFields);
        }

        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfiguration> {
        public Builder resourceArn(String var1);

        public Builder logDestinationConfigs(Collection<String> var1);

        public Builder logDestinationConfigs(String ... var1);

        public Builder redactedFields(Collection<FieldToMatch> var1);

        public Builder redactedFields(FieldToMatch ... var1);

        public Builder redactedFields(Consumer<FieldToMatch.Builder> ... var1);
    }
}

