/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafregional.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.waf.model.UpdateWebACLRequest;
import software.amazon.awssdk.services.waf.transform.UpdateWebACLRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateWebACLRequestMarshaller
implements Marshaller<Request<UpdateWebACLRequest>, UpdateWebACLRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSWAF_Regional_20161128.UpdateWebACL").serviceName("WAF Regional").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateWebACLRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateWebACLRequest> marshall(UpdateWebACLRequest updateWebACLRequest) {
        Validate.paramNotNull((Object)((Object)updateWebACLRequest), (String)"updateWebACLRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)updateWebACLRequest);
            protocolMarshaller.startMarshalling();
            UpdateWebACLRequestModelMarshaller.getInstance().marshall(updateWebACLRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

