/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.ListWebACLsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListWebACLsRequestModelMarshaller {
    private static final MarshallingInfo<String> NEXTMARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextMarker").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final ListWebACLsRequestModelMarshaller INSTANCE = new ListWebACLsRequestModelMarshaller();

    private ListWebACLsRequestModelMarshaller() {
    }

    public static ListWebACLsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListWebACLsRequest listWebACLsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listWebACLsRequest), (String)"listWebACLsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listWebACLsRequest.nextMarker(), NEXTMARKER_BINDING);
            protocolMarshaller.marshall((Object)listWebACLsRequest.limit(), LIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

